#!/usr/bin/python
# coding: utf-8
import utils.common.log as logger

from plugins.CSBS.common import node_installer
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.util import check_url_param


class CTSServerConfig(node_installer.Installer):
    def __init__(self, project_id, pod_id, client):
        super(CTSServerConfig, self).__init__()
        self.param_tool = ParamTool(project_id, pod_id)
        self.karbor_util = KarborUtil(project_id, pod_id)
        self.karbor_node_list = self.karbor_util.get_karbor_node_list()
        self.oc_cts_url = self.param_tool.get_oc_url()
        self.karbor_client = client

    def cts_server_config(self, karbor_node):
        karbor_client = SshClient()
        logger.info('Ssh to karbor node: {}'.format(karbor_node.ip))
        if self.karbor_client:
            ssh_client = self.karbor_client
        else:
            ssh_client = karbor_client.get_ssh_client(karbor_node)
        if not ssh_client:
            return False
        # noinspection PyBroadException
        check_url_param(self.oc_cts_url)
        oc_cts_url_cmd = f"source /opt/huawei/dj/inst/utils.sh;set_karbor_endpoints " \
                         f"--cts_endpoint {self.oc_cts_url}"
        logger.info('Cmd: {}'.format(oc_cts_url_cmd))
        result = karbor_client.ssh_exec_command_return(ssh_client,
                                                       oc_cts_url_cmd)
        if not karbor_client.is_ssh_cmd_executed(result):
            karbor_client.ssh_close(ssh_client)
            logger.error('Failed executing: {}'.format(oc_cts_url_cmd))
            return False
        cts_enable_cmd = "source /opt/huawei/dj/inst/utils.sh;set_cts_cfg --enable true --retry_interval 300"
        logger.info('Cmd: {}'.format(cts_enable_cmd))
        result = karbor_client.ssh_exec_command_return(ssh_client, cts_enable_cmd)
        if not karbor_client.is_ssh_cmd_executed(result):
            logger.error('Failed executing: {}'.format(cts_enable_cmd))
            return False
        return True

    def install(self):
        return self.cts_server_config(self.karbor_node_list[0])

    def rollback(self):
        return True

    def check(self):
        return True
