import utils.common.log as logger
from utils.business.sdr_util import SDRApi
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.constant import RegisterSDRData
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class RegisterSDR(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(RegisterSDR, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.sdr = SDRApi(project_id)
        self.region_id = ParamTool(self.project_id, self.pod_id).get_region_id()
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.register_sdr_data = RegisterSDRData(self.region_id, self.karbor_util.get_karbor_float_ip())

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start to register SDR.")
        try:
            self.sdr.reg_plugin(self.register_sdr_data.appbs_data)
        except Exception as e:
            logger.error(f"Failed to register SDR, err_msg: {str(e)}")
            return Message(500, HCCIException("640001", str(e)))
        logger.info("Succeed to register SDR.")

        try:
            result = self.karbor_util.change_meter_switch(tar_status="on")
        except Exception as e:
            logger.error(f"Failed to register SDR, err_msg: {str(e)}")
            return Message(500, HCCIException("640001", str(e)))

        if not result:
            return Message(500, "Failed to turn on meter switch.")
        logger.info("Register SDR all finished.")
        return Message(200)
