import utils.common.log as logger
from utils.business.manageone_util2 import ManageOneUtil2
from utils.common.message import Message

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.util import check_url_param

logger.init("CSBS")


class ConfigOCAlarm(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ConfigOCAlarm, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.service_name = "CSBS-VBS"
        self.param_tool = ParamTool(self.project_id, self.pod_id)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.mo_util2 = ManageOneUtil2()
        self.thirdpart_account, self.thirdparty_pwd = \
            self.mo_util2.getThirdpartyInfor(self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._config_oc_alarm()
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, f"Failed to config oc alarm, err_msg:{e}")
        logger.info("Succeed to config oc alarm.")
        return Message(200)

    def _config_oc_alarm(self):
        self._add_xaas_white_list()
        self._config_alarm_endpoint()

    def _add_xaas_white_list(self):
        logger.info("Start to add xaas white list.")
        result = self.mo_util2.addXaasWhiteList(
            pod_id=self.pod_id,
            sysName=self.service_name,
            ipList=self.karbor_util.get_karbor_ip_list(),
            region="",
            groupType="",
            logicRegion=self.param_tool.get_region_name(),
            restProtocol="1",
            snmpProtocol="",
            floatIp=self.karbor_util.get_karbor_float_ip())
        if not result:
            raise Exception("Failed to add xaas white list.")
        logger.info("Succeed to add xaas white list.")

    def _config_alarm_endpoint(self):
        karbor_client = SshClient()
        oc_alarm_endpoint = f"{self.param_tool.get_oc_url()}/oc/v2.3"
        # 校验endpoint
        check_url_param(oc_alarm_endpoint)

        logger.info(f"Start to set_alarm_endpoint, "
                    f"alarm endpoint: {oc_alarm_endpoint}.")
        cmd = f"source /opt/huawei/dj/inst/utils.sh;set_alarm_endpoint --alarm_url {oc_alarm_endpoint}"
        ssh_client = karbor_client.get_ssh_client(
            self.karbor_util.get_karbor_node_list()[0])
        karbor_client.ssh_send_command_expect(
            ssh_client, cmd, "user name", 30)
        karbor_client.ssh_send_command_expect(
            ssh_client, self.thirdpart_account, "password", 30)
        result = karbor_client.ssh_send_command_expect(
            ssh_client, self.thirdparty_pwd, "Successfully", 30)
        logger.info(result)
        karbor_client.ssh_close(ssh_client)
        if karbor_client.failed_to_return(result, "Successfully", ssh_client):
            raise Exception("Failed to config alarm endpoint for karbor node.")
        logger.info("Succeed to config alarm endpoint for karbor node.")
