import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.deploy.karbor_az import ConfigAz
from plugins.CSBS.common.ebackup_util import EBackupUtil
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("KarborAZ")


class KarborAZ(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(KarborAZ, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.karbor_node = None
        self.az_list = []
        self.ebackup_util = EBackupUtil(self.project_id, self.pod_id)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self._get_az_and_karbor_node()
        self.config_az = ConfigAz(self.project_id, self.pod_id)

    def _get_az_and_karbor_node(self):
        self.karbor_node = self.karbor_util.get_karbor_node_list()[0]
        logger.info(f'Get karbor node:{self.karbor_node.ip} success.')
        ebackup_az = self.ebackup_util.get_ebackup_az()
        if ebackup_az:
            self.az_list = ebackup_az.split(',')
        logger.info(f'Get az:{self.az_list} success.')

    def _exec_cmd(self, action="add"):
        for az in self.az_list:
            if action == 'add':
                result = self.config_az.add_az(az)
            else:
                result = self.config_az.delete_az(az)
            if not result:
                return Message(500, HCCIException("640049"))
        logger.info(f'Succeed to config karbor az backup.')
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info('Start to config karbor az backup.')
        try:
            return self._exec_cmd()
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, HCCIException("640049"))

    def rollback(self, project_id, pod_id, regionid_list=None):
        try:
            return self._exec_cmd(action="delete")
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, HCCIException("640049"))
