import time

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karbor.cbs_installer import cbs_karborhealth

logger.init("KarborCheck")
RETRY = 15


class KarborCheck(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(KarborCheck, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id

    def execute(self, project_id, pod_id, regionid_list=None):
        retry = 0
        error_service = ""
        logger.info('Start performing a Post-installation Check')
        while retry <= RETRY:
            try:
                if self._config_karbor(project_id, pod_id, retry):
                    retry += 1
                    continue
                else:
                    logger.info('Succeed performing a Post-installation Check')
                    return Message(200)
            except Exception as e:
                logger.error(f"Execute error:{str(e)}")
                return Message(500, HCCIException(640001, str(e)))
        return Message(500, HCCIException(640056, error_service))

    def _config_karbor(self, project_id, pod_id, retry):
        error_service = ""
        configure = cbs_karborhealth.KarborHealth(project_id, pod_id)
        if not configure.install():
            for err_info in configure.error_service:
                error_service = error_service + " " + err_info
            error_service = error_service + " is fault;"
            logger.error(f"Execute error:{error_service}")
            time.sleep(60)
            logger.error(f"Start retry:{retry}")
            return True
        return False

    def rollback(self, project_id, pod_id, regionid_list=None):
        try:
            if not cbs_karborhealth.KarborHealth(project_id, pod_id).rollback():
                return Message(500, HCCIException(640056, " "))
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, HCCIException(640001, str(e)))
        return Message(200)
