import os

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karbor.cbs_installer import cbs_configureset, cbs_karborinstaller

logger.init("KarborInstall")


class KarborInstall(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(KarborInstall, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.param_tool = ParamTool(project_id, pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        # 重新写入sys.ini
        logger.info('Start writing params configuration to sys.ini')
        try:
            install_result = cbs_configureset.ConfigureSet(project_id, pod_id).install()
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, HCCIException("640039"))
        if not install_result:
            return Message(500, HCCIException("640039"))
        logger.info('Succeed writing params configuration to sys.ini')

        sys_file_in_fcd = self.param_tool.get_installer_config()
        logger.info('Start installing karbors')
        try:
            install_result = cbs_karborinstaller.KarborInstaller(project_id, pod_id).install(True)
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, HCCIException("640045"))

        if not install_result:
            return Message(500, HCCIException("640045"))
        logger.info('Succeed installing karbors')
        logger.info('Delete sys.ini in HCC Turnkey after installing karbor')
        os.remove(sys_file_in_fcd)
        logger.info('All finished')
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list=None):
        try:
            install_result = cbs_configureset.ConfigureSet(project_id, pod_id).install()
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, HCCIException("640039"))
        if not install_result:
            return Message(500, HCCIException("640039"))

        try:
            rollback_result = cbs_karborinstaller.KarborInstaller(project_id, pod_id).rollback()
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, HCCIException("640045"))
        if not rollback_result:
            return Message(500, HCCIException("640045"))
        return Message(200)
