import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karbor.cbs_installer import cbs_karboros
from plugins.CSBS.scripts.deploy.karbor.cbs_installer import cbs_securitygoups

logger.init("CSBS")


class OSConfig(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(OSConfig, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info('Start configuring security group')
        try:
            securitygoups_install_result = cbs_securitygoups.SecurityGroups(project_id, pod_id).install()
        except Exception as e:
            logger.error(f"configuring security group execute error:{e}")
            return Message(500, HCCIException("640039"))
        if not securitygoups_install_result:
            return Message(500, HCCIException("640039"))
        logger.info('Succeed configuring security group')

        logger.info('Start configuring Karbor OS')
        try:
            karbor_install_result = cbs_karboros.KarborOS(project_id, pod_id).install()
        except Exception as e:
            logger.error(f"configuring Karbor OS execute error:{e}")
            return Message(500, HCCIException("640041"))
        if not karbor_install_result:
            return Message(500, HCCIException("640041"))
        logger.info('Succeed configuring Karbor OS')
        logger.info('All finished')
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list=None):
        try:
            karbor_rollback_result = cbs_karboros.KarborOS(project_id, pod_id).rollback()
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, HCCIException("640043"))
        if not karbor_rollback_result:
            return Message(500, HCCIException("640043"))

        try:
            securitygoups_rollback_result = cbs_securitygoups.SecurityGroups(project_id, pod_id).rollback()
        except Exception as e:
            logger.error(f"Execute error:{e}")
            return Message(500, HCCIException("640044"))
        if not securitygoups_rollback_result:
            return Message(500, HCCIException("640044"))
        return Message(200)
