import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karbor.accounts import Accounts

logger.init("CSBS")


class RegisterDNS(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(RegisterDNS, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.accounts = Accounts(project_id, pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info('Start registering DNS')
        try:
            self.accounts.register_dns()
        except HCCIException as e:
            logger.error(f"Execute error:{str(e)}")
            return Message(500, e)
        except Exception as e:
            logger.error(f"Execute error:{str(e)}")
            return Message(500, HCCIException(640007, str(e)))
        logger.info('Succeed registering DNS')
        return Message(200)
