import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.dmk_tool import DmkTool
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")
RETRY = 3


class ResetDmkFirstLogin(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ResetDmkFirstLogin, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.dmk_tool = DmkTool(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info('Start to reset dmk first login.')
        try:
            self.dmk_tool.reset_dmk_first_login()
        except HCCIException as e1:
            logger.error(f"Reset dmk first login failed, err_msg:{str(e1)}.")
            return Message(500, e1)
        except Exception as e:
            logger.error(f"Execute error:{str(e)}.")
            return Message(500, HCCIException(640007, str(e)))

        logger.info('Succeed to reset dmk first login.')
        return Message(200)
