import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.deploy.karbor_az import ConfigAz
from plugins.CSBS.common.ebackup_util import EBackupUtil
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("KarborAZ")


class KarborAZ(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(KarborAZ, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.karbor_node = None
        self.available_zone_list = []
        self.ebackup_util = EBackupUtil(self.project_id, self.pod_id)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.config_az = ConfigAz(self.project_id, self.pod_id)
        self._get_az_and_karbor_node()

    def _get_az_and_karbor_node(self):
        self.karbor_node = self.karbor_util.get_karbor_node_list()[0]
        logger.info(f'Get karbor node:{self.karbor_node.ip} success.')
        ebackup_az = self.ebackup_util.get_ebackup_az()
        if ebackup_az:
            self.available_zone_list = ebackup_az.split(',')
        logger.info(f'Get az:{self.available_zone_list} success.')

    def _exec_cmd(self):
        for available_zone in self.available_zone_list:
            if self.config_az.check_az_exists(available_zone):
                logger.info(f'Az {available_zone} already exists,no need to config.')
            else:
                result = self.config_az.add_az(available_zone)
                if not result:
                    return Message(500, HCCIException("640049"))
        logger.info('Succeed to config karbor available_zone backup.')
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info('Start to config karbor az backup.')
        try:
            return self._exec_cmd()
        except Exception as exception:
            logger.error(f"Execute error:{exception}")
            return Message(500, HCCIException("640049"))
