import requests

from utils.common.exception import HCCIException
import utils.common.log as logger


def data_handler(db_script_function):
    def inner(project_id, pod_id, *args, **kwargs):
        rsp = db_script_function(project_id, pod_id, *args, **kwargs)
        if rsp.status_code != 200:
            logger.error("rest req return not 200.")
            raise HCCIException(653020, '')

        rsp.errcode = rsp.json()["error"]["code"]
        rsp.description = rsp.json()["error"]["description"]

        if not rsp.errcode:
            logger.error("errcode is empty.")
            raise HCCIException(653019, '')

        if not rsp.description:
            logger.error("description is empty.")
            raise HCCIException(653019, '')

        if rsp.errcode != 0:
            logger.error("failed,description:" + rsp.description)
            raise HCCIException(653027, rsp.description)
        rsp.token = rsp.json()["data"]["iBaseToken"]
        rsp.cookie = rsp.headers.get('Set-Cookie')
        rsp.session_content = rsp.cookie.split(';')[0]
        return rsp

    return inner


class AgentProxyRest:
    def __init__(self):
        self.name = 'eBackupRest'

    @data_handler
    def post(self, url, headers, data=None):
        """
        :param url:
        :param headers:
        :param data:
        :return: rsponse
        """
        rsp = requests.post(url, headers=headers, data=data, verify=False)
        return rsp

    @data_handler
    def delete(self, url, headers, data=None):
        """
        :param url:
        :param headers:
        :param data:
        :return: rsponse
        """
        rsp = requests.delete(url, headers=headers, data=data, verify=False)
        return rsp

    @data_handler
    def put(self, url, headers, data=None):
        """
        :param url:
        :param headers:
        :param data:
        :return: rsponse
        """
        rsp = requests.put(url, headers=headers, data=data, verify=False)
        return rsp

    @data_handler
    def patch(self, url, headers, data):
        """
        :param url:
        :param headers:
        :param data:
        :return: rsponse
        """
        rsp = requests.patch(url, headers=headers, data=data, verify=False)
        return rsp

    @data_handler
    def get(self, url, headers, data):
        """
        :param url:
        :param headers:
        :param data:
        :return: rsponse
        """
        rsp = requests.get(url, headers=headers, data=data, verify=False)
        return rsp

# the code has been updated to python3.7
