import sys
import threading
import traceback


class ProxyThreading(threading.Thread):
    def __init__(self, func_name, *args):
        threading.Thread.__init__(self)
        self.args = args
        self.func_name = func_name
        self.exitcode = 0
        self.exception = None
        self.exc_traceback = ''

    def run(self):
        try:
            self._run()
        except Exception as e:
            self.exitcode = 1
            self.exception = e
            self.exc_traceback = ''.join(
                traceback.format_exception(*sys.exc_info()))

    def _run(self):
        try:
            self.func_name(*self.args)
        except Exception as e:
            raise e
