import time

import utils.common.log as logger
from utils.common.exception import HCCIException

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxy
from plugins.CSBS.scripts.deploy.karborproxy.config.file_path import FilePath
from plugins.CSBS.scripts.deploy.karborproxy.config.project_set import project_preset
from plugins.CSBS.scripts.deploy.karborproxy.config.shell_cmd import ShellCmd
from plugins.CSBS.scripts.deploy.karborproxy.config.ssh_cmd import SShCmd

logger.init("eBackup KarborProxy vm")


class ConfigAgentProxyVM(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ConfigAgentProxyVM, self).__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd()
        self.agent_proxy = AgentProxy(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("exec Uploading Data Disk Files")
        self._upload_set_disk_file()
        logger.info("Installing and Setting Data Disks")
        self._set_data_disk()

    def _upload_set_disk_file(self):
        retry_count = 0
        while retry_count < 20:
            try:
                self.ssh.put_file_to_all_roots(
                    self.agent_proxy, FilePath.SET_DISK_FILE)
            except HCCIException as e:
                logger.error("ssh connect failed.%s" % e)
                retry_count = retry_count + 1
                time.sleep(30)
                continue
            except Exception as e:
                logger.error("ssh connect failed.%s" % e)
                retry_count = retry_count + 1
                time.sleep(30)
                continue
            logger.info("put file succ.")
            break

    def _set_data_disk(self):
        retry_count = 0
        while retry_count < 20:
            try:
                self.ssh.ssh_root_cmds_to_all_nodes(
                    self.agent_proxy, ShellCmd.set_disk_cmd)
            except HCCIException as e:
                logger.error("ssh connect failed.%s" % e)
                retry_count = retry_count + 1
                time.sleep(30)
                continue
            except Exception as e:
                logger.error("ssh connect failed.%s" % e)
                retry_count = retry_count + 1
                time.sleep(30)
                continue
            logger.info("config set data disk succ.")
            break
