import utils.common.log as logger
from utils.Driver.CloudDC.OpenStack.Network.networkutils import ExcludeRelayCidrManager
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxy


class UpdateCidr(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        logger.info("SFS-DJ")
        super().__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.agent_proxy = AgentProxy(project_id, pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        cidr_manager = ExcludeRelayCidrManager(self.project_id, self.pod_id)
        try:
            cidr_manager.update_exclude_relay_cidr(self.agent_proxy.innet_service_cidr, "CSBS")
        except Exception as e:
            msg = "update cidr failed: %s" % e
            logger.error(msg)
            return Message(500, msg, msg)
        return Message(200)
