import utils.common.log as logger
from utils.business.param_util import ParamUtil
from utils.business.vm_util import PublicServiceOM
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init('CSBS_ExpansionVM')


class ExpansionVM(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ExpansionVM, self).__init__(project_id, pod_id, regionid_list)
        self._project_id = project_id
        self._pod_id = pod_id
        self.params = ParamUtil()
        params_dict = self.params.get_service_cloud_param(pod_id, "CSBS-VBS")
        self.vm_mem = int(params_dict['CSBS_mem'])
        self.vm_cpu = int(params_dict['CSBS_cpu'])
        self.vm_name_info = {'Service-CSBS': 'CSBS_8u16g',
                             'Service-CSBS2': 'CSBS2_8u16g',
                             'Service-CSBS3': 'CSBS3_8u16g',
                             'Service-CSBSdr': 'CSBSdr_8u16g'}

    def resize_vms(self, server_name='Service'):
        vms_detail = PublicServiceOM().get_vm_detail_info(self._pod_id, server_name)
        if not vms_detail:
            raise Exception('there is no vms in vms_detail, please check server_name:{}'.format(server_name))
        logger.info('old vm detail: %s' % str(vms_detail))
        for vm_info in vms_detail:
            origin_vcpus = int(vm_info["vcpus"])
            origin_ram = int(vm_info["ram"]) / 1024
            origin_vm_name = vm_info['name']
            if origin_vm_name not in list(self.vm_name_info.keys()):
                continue
            logger.info(f'Succeed matched to the vm: {origin_vm_name}')
            if all((origin_vcpus == 4, origin_ram == 8, self.vm_cpu == 8, self.vm_mem == 16)):
                logger.info(f'Start to resize, vm name: {origin_vm_name}')
                vm_id = vm_info["id"]
                PublicServiceOM().resize_vm(self._pod_id, vm_id, server_name,
                                            self.vm_name_info[origin_vm_name], self.vm_cpu, self.vm_mem,
                                            0, 150)
                logger.info(f'Succeed to resize vm, vm id: {vm_id}, vm name: {origin_vm_name}')
        vms_detail_new = PublicServiceOM().get_vm_detail_info(self._pod_id, server_name)
        logger.info('new karbor vm detail: %s' % str(vms_detail_new))

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._expansion_karbor_vm(project_id, pod_id)
        except HCCIException as e:
            logger.info('failed to ExpansionVM for karbor vms!')
            return Message(500, e)
        except Exception as ex:
            logger.info('failed to ExpansionVM for karbor vms!')
            return Message(500, str(ex))
        logger.info('succeed to ExpansionVM for karbor vms!')
        return Message(200)

    def _expansion_karbor_vm(self, project_id, pod_id):
        self.pre_check(project_id, pod_id)
        self.resize_vms()

    def retry(self, project_id, pod_id, regionid_list=None):
        rollback_result = self.rollback(project_id, pod_id)
        if rollback_result.status_code == 500:
            return rollback_result
        else:
            return self.execute(project_id, pod_id)
