import time

import utils.common.log as logger

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.modification.region_con_ha.karborproxy.config.agent_proxy_param import AgentProxy
from plugins.CSBS.scripts.modification.region_con_ha.karborproxy.config.project_set import project_preset
from plugins.CSBS.scripts.modification.region_con_ha.karborproxy.config.ssh_cmd import SShCmd


class KarborProxyAftCheck(DeployBaseSubJob):

    def __init__(self, project_id, pod_id, regionid_list=None):
        logger.init("KarborProxy")
        super().__init__(project_id, pod_id, regionid_list)
        self.agent_proxy = AgentProxy(project_id, pod_id)
        self.ssh = SShCmd()

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self.check_omm_ha()
        self.check_haproxy()
        self.check_cps_monitor()
        self.check_agentproxy()
        self.check_zookeeper()
        self.check_v_zookeeper()

    def check_omm_ha(self):
        self.config_ha_retry()

    def check_haproxy(self):
        logger.info('haproxy status check started.')
        haproxy_status_cmd = 'haproxyControl -CS CompontState;' \
                             'echo haproxy status check result $?'
        self.ssh.ssh_cmds_to_all_proxys(self.agent_proxy, haproxy_status_cmd)

    def check_cps_monitor(self):
        logger.info('cps_monitor status check started.')

        cps_monitor_status_cmd = 'cps-monitorControl -CS CompontState;' \
                                 'echo cps-monitor status check result $?'
        self.ssh.ssh_cmds_to_all_proxys(
            self.agent_proxy, cps_monitor_status_cmd)

    def check_agentproxy(self):
        logger.info('agentproxy status check started.')
        agent_proxy_status_cmd = 'agentproxyControl -CS CompontState;' \
                                 'echo agentproxy status check result $?'
        self.ssh.ssh_cmds_to_all_proxys(
            self.agent_proxy, agent_proxy_status_cmd)

    def check_zookeeper(self):
        """
            # 0 单节点
            # 2 主
            # 3 备
            # 1 失败
        :return:
        """
        zook_success_status = ['0', '2', '3']
        logger.info('zookeeper status check started.')
        query_zookeeper_status_cmd = 'zookeeperControl  -CS CompontState;' \
                                     'echo ZooKeeper status check result $?'

        self.ssh.ssh_cmds_to_all_proxys(
            self.agent_proxy, query_zookeeper_status_cmd, zook_success_status)

    def check_v_zookeeper(self):
        """
             0 单节点
             2 主
             3 备
             1 失败
        """
        zook_success_status = ['0', '2', '3']
        logger.info('v_zookeeper status check started.')
        query_zookeeper_status_cmd = 'v_zookeeperControl  -CS CompontState;' \
                                     'echo V_ZooKeeper status check result $?'

        node = self.agent_proxy.get_proxy_node_list()[0]
        self.ssh.ssh_cmds_to_proxy(
            node,
            query_zookeeper_status_cmd,
            zook_success_status
        )

    def config_ha_retry(self):
        retry_count = 0
        while retry_count < 10:
            try:
                self.check_omm_ha_status()
                break
            except Exception as e:
                logger.error("ssh connect failed.%s" % e)
                retry_count = retry_count + 1
                if retry_count == 10:
                    raise Exception('Failed to configure the OMM HA.') from e
                time.sleep(60)

    def check_omm_ha_status(self):
        query_ha_status_cmd = 'omm-haControl -CS CompontState;' \
                              ' echo omm_ha status $?'
        for obj in self.agent_proxy.get_proxy_node_list():
            ha_success_status = ['0', '2', '3']
            self.ssh.ssh_cmds(
                obj, query_ha_status_cmd, ha_success_status)
