import time

import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message
from utils.common.message import RESULT_CODE

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.modification.region_con_ha.karbor.tools.karbor_health import KarborHealth

logger.init("CSBS")

RETRY_TIME = 10


class CheckKarbor(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(CheckKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.karbor_health = KarborHealth(self.karbor_util.get_karbor_node_list())

    def execute(self, project_id, pod_id, regionid_list=None):
        retry = 0
        error_service = ""
        logger.info('Start performing a Post-installation Check')
        while retry < RETRY_TIME:
            error_service = ""
            try:
                if self.karbor_health.install():
                    logger.info('The karbor service are normal.')
                    return Message(RESULT_CODE['SUCCESS'])
            except Exception as e:
                logger.error(f"Execute error:{str(e)}")
                return Message(RESULT_CODE['ERROR'], HCCIException(640001, str(e)))
            for err_info in self.karbor_health.error_service:
                error_service = error_service + " " + err_info
            error_service = error_service + " is fault;"
            logger.error(f"Execute error:{error_service}.")
            retry += 1
            time.sleep(30)
            logger.error(f"Start retry:{retry}.")
        return Message(RESULT_CODE['ERROR'], HCCIException(640056, error_service))

    def rollback(self, project_id, pod_id, regionid_list=None):
        try:
            if not self.karbor_health.rollback():
                return Message(RESULT_CODE['ERROR'], HCCIException(640056, " "))
        except Exception as e:
            logger.error(f"Execute error:{str(e)}")
            return Message(RESULT_CODE['ERROR'], HCCIException(640001, str(e)))
        return Message(RESULT_CODE['SUCCESS'])
