import utils.common.log as logger
from utils.common.message import Message
from utils.common.message import RESULT_CODE

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class PreOperation(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(PreOperation, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._stop_all_karbor_service()
        except Exception as e:
            logger.error(f"Execute error:{str(e)}")
            return Message(RESULT_CODE['ERROR'],
                           "Failed to execute karbot pre operation, "
                           f"err_msg:{str(e)}.")

        logger.info("Succeed to execute karbor pre operation.")
        return Message(RESULT_CODE['SUCCESS'])

    def _stop_all_karbor_service(self):
        karbor_client = SshClient()
        cmd = "source /opt/huawei/dj/inst/utils.sh;DJserviceControl stop"
        for node in self.karbor_util.get_karbor_node_list():
            ssh_client = karbor_client.get_ssh_client(node)
            result = karbor_client.ssh_exec_command_return(ssh_client, cmd)
            if not karbor_client.is_ssh_cmd_executed(result):
                logger.error("Failed to stop karbor service, "
                             f"node ip:{node.ip}.")
                karbor_client.ssh_close(ssh_client)
                raise Exception("Failed to stop karbor service, "
                                f"node ip:{node.ip}.")
            logger.info("Succeed to stop karbor service, "
                        f"node ip:{node.ip}.")
            karbor_client.ssh_close(ssh_client)
        logger.info("Succeed to stop service for all karbor nodes.")
