import os
import subprocess

from utils.common.exception import HCCIException
import utils.common.log as logger
from utils.common.param_check import check_param_ip, check_param_integer

from plugins.CSBS.common.util import check_shell_inject_args
from plugins.CSBS.scripts.modification.region_con_ha.karborproxy.libs.api_adapter import API


def exe_shell_get_result(cmd):
    check_shell_inject_args(cmd)
    exc_result = subprocess.Popen(
        args=["/bin/bash", "-c", cmd],
        shell=False,
        stdout=subprocess.PIPE,
        stderr=subprocess.STDOUT
    )
    out, _ = exc_result.communicate(timeout=300)
    result = out.decode().strip()
    return result


def get_os_file(os_file_name, os_zip_file_name):
    _, os_template = API.find_file(
        os_file_name, ".qcow2", scan_subdir=False)
    if not os_template:
        zippath, zipname = API.find_file(
            "OceanStor BCManager", os_zip_file_name, scan_subdir=False)
        if not zipname:
            raise HCCIException(
                640091, "OceanStor BCManager..." + os_zip_file_name)
        file_path = os.path.join(zippath, zipname)
        API.extract_file(file_path, "/home/pkg/")
        _, os_template = API.find_file(
            os_file_name, ".qcow2", scan_subdir=False)
    logger.info("find " + os_file_name + " succ.")
    return os_template


def check_url_list(value, ip_version):
    ip_version = int(ip_version[-1])
    for sub_url in value.split(','):
        if ip_version == 4:
            urlinfo = sub_url.split(':')
        else:
            urlinfo = []
            start_index = sub_url.find('[')
            if start_index != 0:
                return False
            end_index = sub_url.find(']')
            if end_index == -1:
                return False
            urlinfo.append(sub_url[start_index + 1:end_index])
            if len(sub_url) < (end_index + 3):
                return False
            if sub_url[end_index + 1] != ':':
                return False
            urlinfo.append(sub_url[(end_index + 2):])

        if len(urlinfo) != 2:
            return False
        if not check_param_ip(urlinfo[0], ip_version):
            return False
        if not check_param_integer(urlinfo[1]):
            return False
    return True
