from utils.common import log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS.scripts.upgrade.karbor.base import BaseSubJob


logger.init("CSBS-VBS")


class CreateDmkAccount(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(CreateDmkAccount, self).__init__(project_id, pod_id,
                                               regionid_list)
        self.dmk_client = DMKClient(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

          Perform installation & configuration.
        """
        logger.info("Start to create the CBS DMK account.")
        try:
            self.dmk_client.create_cbs_account_for_upgrade()
        except Exception as e:
            logger.error(f"Failed to create DMK Account, err_msg:{str(e)}.")
            return Message(500, HCCIException(645027))
        return Message(200)
