import utils.common.log as logger
from utils.common.message import Message

from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.scripts.upgrade.karbor.base import BaseSubJob

logger.init("CSBS-VBS")


class DelKarborDirs(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super().__init__(project_id, pod_id, regionid_list)
        self.ssh_client = SshClient()
        self.karbor_operation = KarborOperation(project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            return self._del_karbor_dirs()
        except Exception as e:
            logger.error(f"Execute error:{e}.")
            return Message(500, f"Execute error:{e}.")

    def _del_karbor_dirs(self):
        logger.info("Start to delete karbor dirs.")
        cmd = "rm -rf /karbor/CSBS;find /karbor -maxdepth 1 -type d -name CSBS|wc -l"
        fail_to_del_karbor_node_list = list()
        for karbor_node in self.karbor_operation.karbor_node_list:
            karbor_client = self.ssh_client.get_ssh_client(karbor_node)
            result = self.ssh_client.ssh_send_command_expect(karbor_client, cmd, "0", 30)
            self.ssh_client.ssh_close(karbor_client)
            if self.ssh_client.failed_to_return(result, "0", karbor_client):
                fail_to_del_karbor_node_list.append(karbor_node)
        if fail_to_del_karbor_node_list:
            raise Exception(f"Failed to del karbor dirs in {fail_to_del_karbor_node_list}.")
        logger.info('Delete karbor dirs success.')
        return Message(200)
