# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.manageone_util import ManageOneUtil
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.constant import RegisterToMOInfo
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.util import auto_retry

logger.init("CSBS-VBS")


class RegisterMetric(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RegisterMetric, self).__init__(project_id, pod_id, regionid_list)
        self.mo_util = ManageOneUtil()
        self.register_info = RegisterToMOInfo(self.region_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start to register csbs and vbs meter metrics.")
        for metric_info in [self.register_info.csbs_metric_info, self.register_info.vbs_metric_info]:
            try:
                result = self._register_meter_metrics(self.pod_id, metric_info)
            except Exception as err:
                logger.error(f"Failed to register metrics, err_msg:{str(err)}.")
                return Message(500, HCCIException(645029))
            if not result:
                return Message(500, "Failed to register meter metrics, please check.")
        logger.info("Succeeded to register csbs and vbs meter metrics.")
        return Message(200)

    @auto_retry(max_retry_times=5, delay_time=60)
    def _register_meter_metrics(self, pod_id, metric_info):
        return self.mo_util.register_meter_metrics(pod_id, metric_info)
