import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.scripts.upgrade.karbor.base import BaseSubJob


logger.init("CSBS-VBS")


class RollbackKarbor(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RollbackKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.dmk_client = DMKClient(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Login dmk and call DMK to rollback Karbor.")
        action = "[Rollback] CSBS-VBS Karbor"
        try:
            result = self.dmk_client.dmk_deploy_karbor(action, self.upgrade_path.karbor_pkg_version)
        except Exception as e:
            logger.error("Failed to rollback Karbor, "
                         "reason: {}.".format(str(e)))
            return Message(500, HCCIException(645012))
        if result:
            logger.info("Rollback Karbor successfully.")
        else:
            return Message(500, HCCIException(645012))
        # stop karbor operation service
        self.karbor_operation.change_operation_service(tar_status="stop")
        return Message(200)
