import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.dmk_client import DMKClient
from plugins.CSBS.scripts.upgrade.karbor.base import BaseSubJob

logger.init("CSBS-VBS")


class UploadKarborPkg(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UploadKarborPkg, self).__init__(project_id, pod_id, regionid_list)
        self.dmk_client = DMKClient(self.params_store)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Upload Karbor upgrade package to karbor nodes
        """
        logger.info("Login dmk and call DMK to upload Karbor upgrade pkg.")
        action = "[Upload] CSBS-VBS Karbor Package"
        try:
            result = self.dmk_client.dmk_deploy_karbor(action, self.upgrade_path.karbor_pkg_version)
        except Exception as e:
            logger.error(f"Upload karbor package to Karbor nodes error, err_msg:{str(e)}.")
            return Message(500, HCCIException(645005))
        if not result:
            logger.error("Failed to upload Karbor upgrade pkg to the service VM.")
            return Message(500, HCCIException(645005))
        logger.info("Upload Karbor upgrade pkg to VM successfully.")
        return Message(200)
