# -*- coding:utf-8 -*-
import utils.common.log as logger

from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.upgrade.karborproxy_params import ProxyDMKClient

logger.init("KarborProxy")


class KarborProxyCreateDmkAccount(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(KarborProxyCreateDmkAccount, self).__init__(project_id, pod_id, regionid_list)
        self.dmk_tool = ProxyDMKClient(self.project_id, self.pod_id, self.regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start to create the CSBS_Proxy DMK account.")
        try:
            self.dmk_tool.create_cbs_account_for_upgrade()
        except Exception as e:
            logger.error(f"Failed to create DMK Account, err_msg:{str(e)}.")
            return Message(500, HCCIException(645027))
        return Message(200)
