import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.karborproxy_params import ProxyDMKClient
from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation
from plugins.CSBS.common.step_base import UpgradeBaseSubJob

logger.init("KarborProxy")


class UploadKarborProxyPkg(UpgradeBaseSubJob):

    def __init__(self, project_id, pod_id, regionid_list):
        super(UploadKarborProxyPkg, self).__init__(project_id, pod_id, regionid_list)
        self.proxy_dmk_client = ProxyDMKClient(self.project_id, self.pod_id, self.regionid_list)
        self.proxy = KarborProxyOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Upload KarborProxy upgrade package to KarborProxy nodes
        """
        logger.info("Login dmk and call DMK to upload KarborProxy upgrade pkg.")

        karborproxy_pkg_version = self.proxy.get_karborproxy_pkg_version()

        action = "[Upload] CSBS-VBS KarborProxy Package"
        try:
            result = self.proxy_dmk_client.dmk_deploy_karborproxy(action, karborproxy_pkg_version)
        except Exception as e:
            logger.error(f"Upload KarborProxy package to KarborProxy nodes error, err_msg:{str(e)}.")
            return Message(500, HCCIException(645049))
        if not result:
            logger.error("Failed to upload KarborProxy upgrade pkg to the service VM.")
            return Message(500, HCCIException(645049))
        logger.info("Upload KarborProxy upgrade pkg to VM successfully.")
        return Message(200)

    # the code has been updated to python3.7
