# -*- coding:utf-8 -*-
import utils.common.log as logger

from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.upgrade.params import ParamsTools
from plugins.CSBS.common.upgrade.karborproxy import ProxySsh
from plugins.CSBS.scripts.deploy.karborproxy.config.project_set import project_preset

logger.init("KarborProxy")


class RestartResourceManager(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super().__init__(project_id, pod_id, regionid_list)
        self.ssh = ProxySsh()
        self.karbor_info = ParamsTools(project_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):

        logger.info("Start restart ResourceManager on the Karbor node.")
        self.restart_resource_manager()

    def restart_resource_manager(self):
        cmds = "source /opt/huawei/dj/inst/utils.sh;" \
               "resource_managerControl -A RESTART;" \
               "echo restart Resource Manager result: $?"
        for karbor_node in self.karbor_info.get_karbor_node_list():
            try:
                listout = self.ssh.ssh_su_root_cmds(
                    karbor_node.ip,
                    cmds,
                    karbor_node.user,
                    karbor_node.user_pwd,
                    karbor_node.root_pwd,
                    22,
                    ""
                )
            except Exception as error:
                logger.warn(f"restart RM fail in karbor node={karbor_node}, error is {error}.")
                continue
            if str(karbor_node.ip) in str(listout):
                break
        else:
            raise Exception("restart RM fail in all karbor node.")
        logger.info("restart RM success.")

# the code has been updated to python3.7
