import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.karborproxy_params import ProxyDMKClient
from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation
from plugins.CSBS.common.step_base import UpgradeBaseSubJob


logger.init("KarborProxy")


class RollbackKarborProxy(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RollbackKarborProxy, self).__init__(project_id, pod_id, regionid_list)
        self.karbor_operation = KarborProxyOperation(self.project_id)
        self.proxy_dmk_client = ProxyDMKClient(self.project_id, self.pod_id, self.regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Login dmk and call DMK to rollback KarborProxy.")

        karborproxy_pkg_version = self.karbor_operation.get_karborproxy_pkg_version()

        action = "[Rollback] CSBS-VBS KarborProxy"
        try:
            result = self.proxy_dmk_client.dmk_deploy_karborproxy(action, karborproxy_pkg_version)
        except Exception as e:
            logger.error("Failed to rollback KarborProxy, reason: {}.".format(str(e)))
            return Message(500, HCCIException(645051))
        if result:
            logger.info("Rollback KarborProxy successfully.")
        else:
            return Message(500, HCCIException(645051))
        # stop KarborProxy operation service

        return Message(200)
