import os
from java.io import File
import time


def check_param(dev_obj):
    if not dev_obj or not isinstance(dev_obj, dict):
        return False
    sftp = dev_obj.get("SFTP")
    if not hasattr(sftp, "getFile"):
        return False
    path = dev_obj.get("collectRetDir")
    if not os.path.isdir(path):
        return False
    return True


def execute(dev_obj):
    if not check_param(dev_obj):
        return False, ""
    try:
        remote_path = "/home/djmanager/DataCollect.tar.gz"
        sftp = dev_obj.get("SFTP")
        path = dev_obj.get("collectRetDir")
        title = str(time.strftime('%Y%m%d%H%M%S', time.localtime(time.time())))
        new_path = os.path.join(path, title)
        dev_obj["collectRetDir"] = new_path
        dev_obj["collectRetFileName"] = os.path.basename(remote_path)
        if not os.path.isdir(new_path):
            os.makedirs(new_path)
        local_path = new_path + File.separator + os.path.basename(remote_path)
        file = File(local_path)
        sftp.getFile(remote_path, file, None)
        return True, ""
    except Exception:
        return False, ""
