#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "${CURRENT_PATH}")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

# 通用SHELL脚本
mkdir -p /opt/huawei/dj/{cfg,etc,bin,inst}
/usr/bin/cp -f "${LINE_ROOT}/bin/run_utils.sh" /opt/huawei/dj/inst/utils.sh
CHECK_RESULT $? "Copy utils.sh failed."
log_info "Copy utils.sh success."

# JRE环境安装
install_dir=$(mktemp -d /tmp/nameXXXXX)
jre_tar=$(find "${LINE_ROOT}/repo/platform/java" -type f -name "jre-*.tar.gz")
tar --no-same-owner -xzf "${jre_tar}" -C "${install_dir}"
mkdir -p /opt/huawei/dj/bin/ && rm -rf /opt/huawei/dj/bin/jre
jre_dir=$(find "${install_dir}" -maxdepth 1 -type d -name "jre*")
/usr/bin/mv -f "${jre_dir}" /opt/huawei/dj/bin/jre && rm -rf "${install_dir}"
CHECK_RESULT $? "Install Jre failed."
log_info "Install Jre success."
cmscbb_jar=$(find "${LINE_ROOT}/repo/platform/java" -type f -name "cmscbb*.jar")
/usr/bin/cp -f "${cmscbb_jar}" /opt/huawei/dj/bin/jre/lib
log_info "Copy cmscbb.jar success."

# 三方证书
cert_dir=$(mktemp -d /tmp/nameXXXXX)
openssl genrsa -out "${cert_dir}/ca.key" 2048
key_pwd=$(mkpasswd -l 10 -s 1 | sed 's/{/(/g' | sed 's/}/)/g')
echo "${key_pwd}" | openssl req -new -key "${cert_dir}/ca.key" -subj "/C=CN/ST=SiChuan/O=Huawei/CN=CBS" -passin stdin -out "${cert_dir}/ca.csr"
openssl x509 -req -days 3650 -in "${cert_dir}/ca.csr" -signkey "${cert_dir}/ca.key" \
-extfile /etc/pki/tls/openssl.cnf -extensions v3_ca -out "${cert_dir}/cacert.pem"
/usr/bin/cp -f "${cert_dir}/cacert.pem" /opt/huawei/dj/bin/python/csbs_python/pip/_vendor/certifi/cacert.pem
/usr/bin/cp -f "${cert_dir}/cacert.pem" /opt/huawei/dj/bin/python/csbs_python/certifi/cacert.pem
rm -rf "${cert_dir}"

# 通用Python工具
basesdk_whl=$(find "${LINE_ROOT}/repo/self_developed" -type f -name "basesdk*.whl")
csbs_python -m pip install --no-deps --force-reinstall "${basesdk_whl}"
CHECK_RESULT $? "Install basesdk failed."
log_info "Install basesdk success."

# 释放数据库驱动
mkdir -p /opt/huawei/dj/bin/gaussdb
tar --no-same-owner --extract --file="${LINE_ROOT}/repo/platform/gaussdb/gaussdb_app.tar.gz" -C /opt/huawei/dj/bin/gaussdb app/lib
CHECK_RESULT $? "Unzip libpq from gaussdb_app failed."

# 设置通用权限
chage -E 9999999999 -M 99999 openstack
set_install_permission
set_common_permission  /opt/huawei/dj
set_common_permission  /var/log/huawei/dj
exit 0