#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="gaussdbRestore"
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
RESTORE_DIR="/opt/huawei/djbackup/db/restore_data"
BACKUP_FILE_NAME="$1"
HOST_IP=$(get_info manage_ip)

function prerestore()
{
    bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh query >/dev/null 2>&1
    ECHO_RETURN $? "GaussDB is not normal on node ${HOST_IP}, can not execute restore task."
    log_info "db state is normal on node ${HOST_IP}, check successfully."
}

function execute_restore()
{
    if [[ -f "${RESTORE_DIR}/${BACKUP_FILE_NAME}.tar.gz" ]];then
        echo_info "Begin to check the size and file count of the gaussdb tar file."
        check_tar_file_before_unzip "${RESTORE_DIR}/${BACKUP_FILE_NAME}.tar.gz"
        ECHO_RETURN $? "Check ${BACKUP_FILE_NAME}.tar.gz failed."
        tar -xzf "${RESTORE_DIR}/${BACKUP_FILE_NAME}.tar.gz" --no-same-owner -C "$(dirname "${RESTORE_DIR}")" >/dev/null 2>&1
        ECHO_RETURN $? "unzip db backupdata failed on node ${HOST_IP}."
        bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh restore >/dev/null 2>&1
        ECHO_RETURN $? "restore database failed on node ${HOST_IP}."
        echo_info "restore database successfully on node ${HOST_IP}."
    else
        ECHO_RETURN 1 "DB Backupdata not exist on node ${HOST_IP}."
    fi
}

function stop_gaussdb()
{
    peer_node=$(get_info db_peer_node)
    echo_info "begin stop gaussdb service on node ${HOST_IP}."
    sh "${CURRENT_PATH}/gaussdb_restore_helper.sh" stopgaussdb
    ECHO_RETURN $? "failed to stop gaussdb service on node ${HOST_IP}."
    echo_info "begin stop gaussdb service on node ${peer_node}."
    cmd_manager --node_ip "${peer_node}" --cmd "${CURRENT_PATH}/gaussdb_restore_helper.sh" --parameters "stopgaussdb"
    ECHO_RETURN $? "failed to stop gaussdb service on node ${HOST_IP}."
}


function start_gaussdb()
{
    peer_node=$(get_info db_peer_node)
    # start gaussdb service with primary
    echo_info "begin start gaussdb to primary on node ${HOST_IP}."
    sh "${CURRENT_PATH}/gaussdb_restore_helper.sh" stopgaussdb
    ECHO_RETURN $? "failed stop gaussdb service when start to primary on node ${HOST_IP}."
    bash /opt/huawei/dj/tools/gaussdb/sync_monitor.sh reset_status
    ECHO_RETURN $? "reset gaussdb status failed when start to primary on node ${HOST_IP}."
    bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh active active >/dev/null 2>&1
    ECHO_RETURN $? "gaussdb start to primary failed on node ${HOST_IP}."
    echo_info "gaussdb start to primary on node ${HOST_IP} success."
    echo_info "begin start gaussdb to standby on node ${peer_node}."
    cmd_manager --node_ip "${peer_node}" --cmd "${CURRENT_PATH}/gaussdb_restore_helper.sh" --parameters "startgaussdb"
    ECHO_RETURN $? "startgaussdb gaussdb data on node ${peer_node} failed."
    echo_info "gaussdb start to standby on node ${peer_node} success."
}


function restore_db()
{
    echo_info "Begin to restore GaussDB on node ${HOST_IP}..."
    prerestore
    stop_gaussdb
    execute_restore
    start_gaussdb
    echo_info "Successfully restored GaussDB on node ${HOST_IP}."
}

function restore_certificate()
{
    echo_info "Begin to restore certificate on node ${HOST_IP}..."
    if [[ -f "${RESTORE_DIR}/${BACKUP_FILE_NAME}.tar.gz" ]];then
        check_tar_file_before_unzip "${RESTORE_DIR}/${BACKUP_FILE_NAME}.tar.gz" /opt/huawei/dj/DJSecurity
        ECHO_RETURN $? "Check ${BACKUP_FILE_NAME}.tar.gz failed."
        tar -P -xzf "/opt/huawei/djbackup/db/restore_data/${BACKUP_FILE_NAME}.tar.gz" >/dev/null 2>&1
        ECHO_RETURN $? "Restore certificate failed on node ${HOST_IP}."
    else
        ECHO_RETURN 1 "Cert Backupdata not exist on node ${HOST_IP}."
    fi
    echo_info "Successfully restored certificate on node ${HOST_IP}."
}

function download_backup_data()
{
    node_ip="$1"
    echo_info "Begin to download ${BACKUP_FILE_NAME} backupdata from ${node_ip} on node ${HOST_IP}..."
    rm -rf ${RESTORE_DIR} && mkdir -p ${RESTORE_DIR} >/dev/null 2>&1
    download_file --node_ip "${node_ip}" --source_file "${RESTORE_DIR}/${BACKUP_FILE_NAME}.tar.gz" \
    --target_file "${RESTORE_DIR}/${BACKUP_FILE_NAME}.tar.gz" >/dev/null 2>&1
    ECHO_RETURN $? "Download backupdata from ${node_ip} failed on node ${HOST_IP}."
}

if [[ "${BACKUP_FILE_NAME}" == "digital_certificate" ]];then
    [[ $# -eq 2 ]] && download_backup_data "$2"
    restore_certificate
elif [[ "${BACKUP_FILE_NAME}" == "rmandatabackup" ]];then
    [[ $# -eq 2 ]] && download_backup_data "$2"
    restore_db
else
    ECHO_RETURN 1 "Not support restore ${BACKUP_FILE_NAME} on node ${HOST_IP}."
fi
