#!/bin/bash
FOR_ENCRYPT="$1"

function ssh_host_sm2_key()
{
    /usr/bin/expect<<-EOF
    set timeout 60
    spawn ssh-keygen -t sm2 -m PEM -f /etc/ssh/ssh_host_sm2_key
    expect {
        "*passphrase*" {
            exec sleep 1
            send "\r"
            send "exit $?\r"
            exp_continue
        }
        "*Overwrite*" {
            exec sleep 1
            send "y\r"
            exp_continue
        }
        "*y/n*" {
            exec sleep 1
            send "y\r"
            exp_continue
        }
        "*same passphrase again:*" {
            exec sleep 1
            send "\r"
            exit 0
        }
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}


function changeToGeneralCipher()
{
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/system-auth
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/password-auth
    sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*sm3/crypt_style = sha512/g" /etc/libuser.conf
    sed -i 's/+sm3//g' /etc/aide.conf &>/dev/null
    sed -i s/rsa-sha2-256,sm2/rsa-sha2-256/g /etc/ssh/sshd_config
    sed -i s/aes256-gcm@openssh.com,sm4-ctr/aes256-gcm@openssh.com/g /etc/ssh/sshd_config
    sed -i s/hmac-sha2-256-etm@openssh.com,hmac-sm3/hmac-sha2-256-etm@openssh.com/g /etc/ssh/sshd_config
    sed -i s/diffie-hellman-group-exchange-sha256,sm2-sm3/diffie-hellman-group-exchange-sha256/g /etc/ssh/sshd_config
    sed -i '/FingerprintHash sm3\|ssh_host_sm2_key/d' /etc/ssh/sshd_config
    rm -f /etc/ssh/ssh_host_sm2_key*
    systemctl restart sshd
}


function changeToSMCipher()
{
    if grep -q "crypt_style = sm3" /etc/libuser.conf;then
        echo "os already use SM algorithm."
        exit 0
    fi
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/system-auth
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/password-auth
    sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*sha512/crypt_style = sm3/g" /etc/libuser.conf
    sed -i '/^FIPSR[[:space:]]*=\|^DATAONLY[[:space:]]*=/ s/$/+sm3/' /etc/aide.conf &>/dev/null
    sed -i s/rsa-sha2-256/rsa-sha2-256,sm2/g /etc/ssh/sshd_config
    sed -i s/aes256-gcm@openssh.com/aes256-gcm@openssh.com,sm4-ctr/g /etc/ssh/sshd_config
    sed -i s/hmac-sha2-256-etm@openssh.com/hmac-sha2-256-etm@openssh.com,hmac-sm3/g /etc/ssh/sshd_config
    sed -i s/diffie-hellman-group-exchange-sha256/diffie-hellman-group-exchange-sha256,sm2-sm3/g /etc/ssh/sshd_config
    echo "FingerprintHash sm3" >> /etc/ssh/sshd_config
    echo "HostKey /etc/ssh/ssh_host_sm2_key" >> /etc/ssh/sshd_config
    ssh_host_sm2_key
    if [ $? != 0 ];then
        exit 1
    else
        systemctl restart sshd
    fi
}


function changeToGeneralCipherR8()
{
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/system-auth
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sm3/password    sufficient    pam_unix.so sha512/g" /etc/pam.d/password-auth
    sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*sm3/crypt_style = sha512/g" /etc/libuser.conf
    sed -i 's/+sm3//g' /etc/aide.conf &>/dev/null
}


function changeToSMCipherR8() {
    if grep -q "crypt_style = sm3" /etc/libuser.conf;then
        echo "os already use SM algorithm."
        exit 0
    fi
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/system-auth
    sed -i "s/^password[[:space:]]*sufficient[[:space:]]*pam_unix.so[[:space:]]*sha512/password    sufficient    pam_unix.so sm3/g" /etc/pam.d/password-auth
    sed -i "s/^crypt_style[[:space:]]*=[[:space:]]*sha512/crypt_style = sm3/g" /etc/libuser.conf
    sed -i '/^FIPSR[[:space:]]*=\|^DATAONLY[[:space:]]*=/ s/$/+sm3/' /etc/aide.conf &>/dev/null
}


function main()
{
    local v2r8=`cat /etc/euleros-release | grep "2.0" | grep "SP8"`
    local v2r9=`cat /etc/euleros-release | grep "2.0" | grep "SP9"`
    local v2r10=`cat /etc/euleros-release | grep "2.0" | grep "SP10"`
    if [[ -n "$v2r8" ]]; then
        if [ "$FOR_ENCRYPT" = "generalCipher" ]; then
            changeToGeneralCipherR8
        else
            changeToSMCipherR8
        fi
    elif [[ -n "$v2r9" ]] || [[ -n "$v2r10" ]]; then
        if [ "$FOR_ENCRYPT" = "generalCipher" ]; then
            changeToGeneralCipher
        else
            changeToSMCipher
        fi
    else
        exit 1
    fi
    echo "config os success"
}

main