#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
echo "######################################################################"
echo "###                     Welcome to the O&M mode                    ###"
echo "###                                                                ###"
echo "###   1.Run 'help' to query O&M commands                           ###"
echo "###   2.Run 'exit' to exit O&M mode                                ###"
echo "######################################################################"
function check_symbol_black_list()
{
    [[ "$*" =~ " -c " ]] && return 1
    [[ "$*" =~ "root" ]] && return 2
    [[ "$*" =~ "sudo" ]] && return 3
    [[ "$*" =~ ^[:A-Za-z0-9/=.\ ,_-]+$ ]] && return 0
    return 4
}

function check_op_svc_password()
{
    echo "The command needs to verify the op_svc_csbs permission."
    (
        echo "from kmc import hard_rest_api"
        echo "try:"
        echo "    exit(hard_rest_api.IamApi().verify_op_svc_csbs())"
        echo "except Exception:"
        echo "    exit(1)"
    ) | csbs_python
}
function check_command_exec_permission()
{
    cmd_level=$(grep "^$1=" /opt/huawei/dj/etc/cli-client/cmd_manager.conf | cut -d= -f2)
    [[ "${cmd_level}" -lt 3 ]] && return 0
    check_op_svc_password
}
while read -rp "##" input_command;do
    [[ "${input_command}" == "exit" ]] && exit 0
    if ! check_symbol_black_list "${input_command}";then
        echo "The command cannot contain special characters."
        continue
    fi
    IFS=" " read -r -a csbs_cmd <<< "${input_command}"
    if ! (grep "^${csbs_cmd[0]}=" /opt/huawei/dj/etc/cli-client/cmd_manager.conf > /dev/null 2>&1);then
        bash /opt/huawei/dj/tools/cli-client/cmd_help.sh
        continue
    fi
    if ! (check_command_exec_permission "${csbs_cmd[0]}");then
        echo "verify command exec permission failed."
        continue
    fi
    ${input_command}
done