#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function upgrade_cms()
{
    log_info "begin cms Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old cms"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new cms"
    tar -P --extract --file="${LINE_ROOT}/old_version_data.tar.gz" /opt/huawei/dj/etc/cms/cms.conf
    CHECK_RESULT $? "failed to restore conf new cms"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new cms"
    log_info "Finish cms Upgrade action."
}

log_info "begin cms Upgrade."
upgrade_cms
touch "${CURRENT_PATH}/cms_upgrade_finish"
log_info "Upgrade cms success."