#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init gaussdb rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/gaussdb
    log_info "Finish gaussdb rsyslog configuration."
}

function install_script()
{
    log_info "Init gaussdb script configuration."
    mkdir -p /opt/huawei/dj/bin/gaussdb/{archive,cert}
    tar -xzf "${LINE_ROOT}/repo/platform/gaussdb/gaussdb_app.tar.gz" --no-same-owner -C /opt/huawei/dj/bin/gaussdb
    CHECK_RESULT $? "install gaussdb fail to unzip gaussdb app"
    if [[ ! -d  /opt/huawei/dj/bin/gaussdb/data ]];then
        tar -xzf "${LINE_ROOT}/repo/platform/gaussdb/gaussdb_data.tar.gz" --no-same-owner -C /opt/huawei/dj/bin/gaussdb
        CHECK_RESULT $? "Unzip gaussdb data failed."
    fi
    install_ommha_resource "${CURRENT_PATH}/ha"
    log_info "Finish gaussdb script configuration."
}

function install_tools()
{
    log_info "Init gaussdb tools configuration."
    mkdir -p /opt/huawei/dj/tools/gaussdb
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/gaussdb
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    CHECK_RESULT $? "Install gaussdb tools Failed."
    log_info "Finish gaussdb tools configuration."
}

function install_version()
{
    log_info "Init gaussdb version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/gaussdb.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy gaussdb version Failed."
    log_info "Finish gaussdb version configuration."
}

function install_permission()
{
    log_info "Init gaussdb permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /opt/huawei/djbackup
    set_common_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/etc/gaussdb/db_sync.conf
    set_modify_permission /opt/huawei/dj/bin/gaussdb/data
    set_modify_permission /var/log/huawei/dj
    log_info "Finish gaussdb permission configuration."
}

function install_root()
{
    log_info "Init gaussdb root configuration."
    log_info "Finish gaussdb root configuration."
}

function install_crontab()
{
    log_info "Init gaussdb crontab configuration."
    log_info "Finish gaussdb crontab configuration."
}

function install_conf()
{
    log_info "Init gaussdb conf configuration."
    mkdir -p /opt/huawei/dj/etc/gaussdb /opt/huawei/djbackup/db
    /usr/bin/cp -f "${CURRENT_PATH}/conf/postgresql.conf" /opt/huawei/dj/bin/gaussdb/data
    CHECK_RESULT $? "Copy the postgresql_conf to gaussdb failed."
    /usr/bin/cp -f "${CURRENT_PATH}/conf/db_sync.conf" /opt/huawei/dj/etc/gaussdb
    CHECK_RESULT $? "Install gaussdb db_sync.conf failed."
    log_info "Finish gaussdb conf configuration."
}

log_info "Start gaussdb installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish gaussdb installation."
