#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init haproxy rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/haproxy
    log_info "Finish haproxy rsyslog configuration."
}

function install_script()
{
    log_info "Init haproxy script configuration."
    haproxy_rpm=$(find "${LINE_ROOT}/repo/third_party" -name "haproxy-*.rpm")
    rpm -Uivh --force --nodeps "${haproxy_rpm}"
    CHECK_RESULT $? "rpm install haproxy_rpm failed."
    haproxyreg_whl=$(find "${LINE_ROOT}/repo/self_developed" -name "haproxyreg*.whl")
    csbs_python -m pip install --no-deps --force-reinstall "${haproxyreg_whl}"
    CHECK_RESULT $? "pip install haproxyreg_whl failed."
    log_info "Finish haproxy script configuration."
}

function install_tools()
{
    log_info "Init haproxy tools configuration."
    mkdir -p /opt/huawei/dj/tools/haproxy
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/haproxy
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/haproxy/haproxyControl.sh
    log_info "Finish haproxy tools configuration."
}

function install_version()
{
    log_info "Init haproxy version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/haproxy.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy haproxy version Failed."
    log_info "Finish haproxy version configuration."
}

function install_permission()
{
    log_info "Init haproxy permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /var/log/huawei/dj
    log_info "Finish haproxy permission configuration."
}

function install_root()
{
    log_info "Init haproxy root configuration."
    log_info "Finish haproxy root configuration."
}

function install_crontab()
{
    log_info "Init haproxy crontab configuration."
    log_info "Finish haproxy crontab configuration."
}

function install_conf()
{
    log_info "Init haproxy conf configuration."
    log_info "Finish haproxy conf configuration."
}

log_info "Start haproxy installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish haproxy installation."
