#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function upgrade_haproxy()
{
    log_info "begin haproxy Upgrade action."
    haproxyinternalControl -S STOP
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old haproxy"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new haproxy"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to start new haproxy"
    log_info "Finish haproxy Upgrade action."
}

log_info "begin haproxy Upgrade."
upgrade_haproxy
touch "${CURRENT_PATH}/haproxy_upgrade_finish"
log_info "Upgrade haproxy success."