#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: inspect_item
# Description: Entrance of this scripts
# Parameter:
# Return: success 0, fail 1
# **************************************************************************** #
function inspect_item()
{
    case $1 in
    karbor_api_process)
        check_karbor_api;;
    karbor_protection_process)
        check_karbor_protection;;
    karbor_operation_process)
        check_karbor_operation;;
    service_status)
        check_service_status;;
    connect_status)
        check_connect_status;;
    esac
}

function check_karbor_api()
{
    # Check if the karbor-api process exists
    line=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/kangaroo-api)
    if [[ -z "${line}" ]];then
        exit 1
    else
        exit 0
    fi
}

function check_karbor_protection()
{
    # Check if the karbor-protection process exists
    line=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/kangaroo-protection)
    if [[ -z "${line}" ]];then
        exit 1
    else
        exit 0
    fi
}

function check_karbor_operation()
{
    # Check if the karbor-operation process exists
    line=$(pgrep -U 51001 -f /opt/huawei/dj/sbin/kangaroo-operation)
    if [[ -z "${line}" ]];then
        exit 1
    else
        exit 0
    fi
}

function check_service_status()
{
    # omm-ha are active and standby
    node_name=$(get_info --hostname)
    fault_service=$(show_service --node "${node_name}" | grep -c  "fault" )
    if [[ ${fault_service} -gt 0 ]];then
        exit 1
    else
        exit 0
    fi
}

function check_connect_status()
{
    verify_cert="$(get_info --certificate_verification_switch)"
    if [[ ${verify_cert} == "True" ]];then
        error_dock=$(check_karbor_connect --scope include_extend | grep -c "Error")
    else
        error_dock=$(check_karbor_connect | grep -c "Error")
    fi

    if [[ ${error_dock} -gt 0 ]];then
        exit 1
    else
        exit 0
    fi
}

inspect_item "$@"
