#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="karbor-run"

function get_cert_time()
{
    cert_path=$1
    cer_date=$(openssl x509 -subject_hash -fingerprint -in "${cert_path}" -noout -text | grep -w 'Not After')
    IFS=" " read -r -a cer_date_arr <<< "${cer_date}"
    cer_date_time=$(date --date="${cer_date_arr[3]} ${cer_date_arr[4]} ${cer_date_arr[6]} ${cer_date_arr[5]}" +%s)
    echo "${cer_date_time}"
}

function get_cert_diff_time()
{
    cer_date_time=$(get_cert_time "$1")
    cur_date_time=$(date +%s)
    diff_time=$((cer_date_time-cur_date_time))
    echo "${diff_time}"
}

# 校验证书
function check_cert()
{
      cert_data=$1
      TEMP_DEST_CERT_FILE=/opt/huawei/dj/DJSecurity/temp.cer
      mkdir -p "$(dirname "${TEMP_DEST_CERT_FILE}")"
      if ! (echo "${cert_data}" | base64 -d > "${TEMP_DEST_CERT_FILE}");then
        log_error "Import cert data failed."
        rm -rf ${TEMP_DEST_CERT_FILE}
        exit 2
    fi

    if ! openssl x509 -subject_hash -fingerprint -in "${TEMP_DEST_CERT_FILE}" -noout -text &>/dev/null;then
        log_error "${TEMP_DEST_CERT_FILE} can not use openssl to check."
        rm -rf ${TEMP_DEST_CERT_FILE}
        exit 2
    fi

    # 校验证书版本
    version=$(openssl x509 -noout -in "${TEMP_DEST_CERT_FILE}" -text | grep 'Version' | awk '{print $2}')
    if [[ ${version} -lt 3 ]]; then
        log_error "Check CA and cert file failed, the version error."
        rm -rf ${TEMP_DEST_CERT_FILE}
        exit 2
    fi

    # 校验证书签名
    signature=$(openssl x509 -noout -in "${TEMP_DEST_CERT_FILE}" -text | grep 'Signature Algorithm' | awk '{print $3}'| head -n 1)
    if [[ "${signature}" != "sha256WithRSAEncryption" ]]; then
        log_error "Check CA and cert file failed, the signature error."
        rm -rf ${TEMP_DEST_CERT_FILE}
        exit 2
    fi

    # 校验证书公钥长度
    key_len=$(openssl x509 -noout -in "${TEMP_DEST_CERT_FILE}" -text | grep 'Public-Key' | awk '{print $3}'| awk -v FS='(' '{print $2}')
    if [[ ${key_len} -lt 2048 ]]; then
        log_error "Check CA and cert file failed, the key_len error."
        rm -rf ${TEMP_DEST_CERT_FILE}
        exit 2
    fi

    # 校验证书有效期
    diff_time=$(get_cert_diff_time "${TEMP_DEST_CERT_FILE}")
    if [[ ${diff_time} -lt 0 ]];then
        log_error "Check CA and cert file failed, the date error."
        rm -rf ${TEMP_DEST_CERT_FILE}
        exit 2
    fi
    rm -rf ${TEMP_DEST_CERT_FILE}
    return 0
}

# 防止并发
if [[ "$(pgrep -U 51001 -f "$0" -d ' ')" != "$$" ]];then
    ECHO_RETURN 1 "The script is running, no need start again."
fi

if [[ "$1" == "openstack" ]] || [[ "$1" == "CSBS_VBS-fsp" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/server-cert/karbor/openstack/nova_ca.crt"
elif [[ "$1" == "apicom" ]] || [[ "$1" == "CSBS_VBS-APICOM" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/mo_certs/apicom_ca.cer"
elif [[ "$1" == "arb" ]] || [[ "$1" == "CSBS_VBS-Arb" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/arb/arb_ca.crt"
elif [[ "$1" == "apigw" ]] || [[ "$1" == "CSBS_VBS-ApiGW" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/mo_certs/apigw_ca.cer"
elif [[ "$1" == "iam" ]] || [[ "$1" == "CSBS_VBS-MO-IAM" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/mo_certs/trust_iam.cer"
elif [[ "$1" == "CSBS_VBS-MO-OC" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/mo_certs/trust_oc.cer"
elif [[ "$1" == "CSBS_VBS-MO-SC" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/mo_certs/trust_sc.cer"
elif [[ "$1" == "iam_global" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/server-ca/global_trust.cer"
elif [[ "$1" == "CSBS_VBS-internal" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/mo_certs/replace_server"
elif [[ "$1" == "ebackup" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/ebk_certs/$2.cer"
elif [[ "$1" == "dpa" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/dpa_certs/$2.cer"
elif [[ "$1" == "karbor" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/karbor_certs/$2.cer"
elif [[ "$1" == "crl" ]];then
    DEST_CERT_FILE="/opt/huawei/dj/DJSecurity/crl/crl_pool.crl"
else
    exit 1
fi
read -rst 60 cert_data

if [[ "$1" != "crl" ]] && [[ "$1" != "CSBS_VBS-internal" ]];then
    check_cert "${cert_data}"
fi

mkdir -p "$(dirname "${DEST_CERT_FILE}")"
echo "${cert_data}" | base64 -d > "${DEST_CERT_FILE}"
exit 0
