#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="omm-haControl"
export LD_LIBRARY_PATH=/opt/huawei/dj/bin/ha/libs:${LD_LIBRARY_PATH}
CIPHER_TYPE=$(get_info cipher_type)
if [[ "${CIPHER_TYPE}" == "SMCompatible" ]];then
    CIPHER_TYPE=1
else
    CIPHER_TYPE=0
fi

function get_encrypted_pwd()
{
    privkey_file="/opt/huawei/dj/DJSecurity/privkey/privkey.conf"
    pas2wd=$(decrypt_pwd "$(awk '{print $2}' ${privkey_file})")
    pas2wd=$(get_safe_password "${pas2wd}")
    G_HA_KEYTOOL="/opt/huawei/dj/bin/ha/module/hacom/tools/key-tool"
    /usr/bin/expect<<-EOF
    set timeout 60
    spawn ${G_HA_KEYTOOL} -a ${CIPHER_TYPE} -i
    expect {
        "Please input password:" {send "${pas2wd}\r"}
    }
    expect {
        "Please input password:" {exit 1}
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function config_openssl()
{
    log_info "Begin config omm ha cert."
    G_HA_CERT_DESTINATION="/opt/huawei/dj/bin/ha/local/cert"
    rm -f ${G_HA_CERT_DESTINATION}/server.key
    encrypted_pwd=$(get_encrypted_pwd | grep "Encrypted" | awk -F: '{print $NF}' | tr -d ' ')
    [[ -z "${encrypted_pwd}" ]] && ECHO_RETURN 1 "encrypted cert failed."
    echo "${encrypted_pwd}" > ${G_HA_CERT_DESTINATION}/server.key
    dos2unix ${G_HA_CERT_DESTINATION}/server.key >> /dev/null 2>&1
    HA_CERT_PATH="/opt/huawei/dj/DJSecurity/server-cert/omm-ha"
    CA_ROOT_PATH="/opt/huawei/dj/DJSecurity/server-ca"
    /usr/bin/cp -f ${HA_CERT_PATH}/omm-ha-key.pem ${G_HA_CERT_DESTINATION}/server.pem
    /usr/bin/cp -f ${HA_CERT_PATH}/omm-ha-cert.pem ${G_HA_CERT_DESTINATION}/server.crt
    /usr/bin/cp -f ${CA_ROOT_PATH}/ca-cert.pem ${G_HA_CERT_DESTINATION}/cacert.pem
    server_key=$(cat ${G_HA_CERT_DESTINATION}/server.key)
    echo "${server_key}" | bash /opt/huawei/dj/bin/ha/module/hacom/script/config_ha.sh -q false -S ssl=true,twoway=true,rootca=${G_HA_CERT_DESTINATION}/cacert.pem,keypass= > /dev/null
    CHECK_RESULT $? "config openssl failed, Please Contact Huawei technical support."
    log_info "Finish config omm ha cert."
}
config_openssl
log_info "config openssl successful."