#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="omm-haControl"
export LD_LIBRARY_PATH=/opt/huawei/dj/bin/ha/libs:${LD_LIBRARY_PATH}

function showhelp()
{
    echo "Usage: omm-haControl: -S ServiceState"
    echo "  -S ServiceState (RUN STOP)"
    echo "  -A RESTART"
    echo "  -CS ComponentState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "omm-haControl: illegal option"
    showhelp
    exit 1
}


function component_run()
{
    echo_info "omm-haControl: component_run begin"
    echo_info "Begin start omm-ha."
    bash /opt/huawei/dj/bin/ha/module/hamon/script/start_ha_monitor.sh >> /dev/null 2>&1
    ECHO_RETURN $? "start omm-ha failed."
    echo_info "Finish start omm-ha."
    echo_info "$(heartBeat START omm-ha)"
    echo_info "omm-haControl: component_run end"
    return 0
}

function component_stop()
{
    echo_info "omm-haControl: component_stop begin"
    echo_info "$(heartBeat STOP omm-ha)"
    echo_info "Begin stop omm-ha monitor."
    bash /opt/huawei/dj/bin/ha/module/hamon/script/stop_ha_monitor.sh >> /dev/null 2>&1
    ECHO_RETURN $? "stop omm-ha monitor failed."
    kill_process /opt/huawei/dj/bin/ha/module/hamon/bin/ha_monitor
    echo_info "Finish stop omm-ha monitor."
    echo_info "Begin stop omm-ha."
    bash /opt/huawei/dj/bin/ha/module/hacom/script/stop_ha.sh > /dev/null 2>&1
    ECHO_RETURN $? "stop omm-ha failed."
    kill_process /opt/huawei/dj/bin/ha/module/hacom/bin/ha.bin
    kill_process /opt/huawei/dj/bin/gaussdb/app/bin/gaussdb
    echo_info "Finish stop omm-ha."
    echo_info "omm-haControl: component_stop end"
    return 0
}

function component_restart()
{
    echo_info "omm-haControl: component_restart begin"
    component_stop
    component_run
    echo_info "omm-haControl: component_restart end"
}

function component_statusget()
{
    queryCmd="$(pgrep -U 51001 -f /opt/huawei/dj/bin/ha/module/hamon/bin/ha_monitor)"
    if [[ -z "${queryCmd}" ]]; then
        ECHO_RETURN 1 "omm-ha is not running."
    fi
    status_info=$(bash /opt/huawei/dj/bin/ha/module/hacom/script/get_harole.sh)
    if [[ "${status_info}X" == "activeX" ]];then
        echo_info "status of omm-ha is active"
        IFS="," read -r -a ha_nodes <<< "$(get_info omm-ha_nodes)"
        [[ "${#ha_nodes[@]}" == "1" ]] && exit 0
        exit 2
    fi
    if [[ "${status_info}X" == "standbyX" ]];then
        echo_info "status of omm-ha is standby"
        exit 3
    fi
    echo_info "status of omm-ha is normal"
    exit 0
}

while true; do
    case "$1" in
        -S) Action1=$2;shift 2;;
        -CS) Action2=$2;shift 2;;
        -A) Action3=$2;shift 2;;
        -h) showhelp;;
        *) shift; break;;
    esac
done

if [ "RESTART" = "${Action3}" ]; then
    component_restart
elif [ "RUN" = "${Action1}" ]; then
    component_run
elif [ "STOP" = "${Action1}" ]; then
    component_stop
elif [ "ComponentState" = "${Action2}" ]; then
    component_statusget
else
    args_err
fi
exit 0
