#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

IFS="," read -r -a ZK_NODES <<< "$(get_info zookeeper_nodes)"
LOCAL_IP=$(get_info local_ip)
DB_FLOAT_IP=$(get_info gaussdb_float_ip)

log_info "Init zookeeper configuration."
get_info node_index > /opt/huawei/dj/bin/zookeeper/data/myid
echo ${#ZK_NODES[@]} > /opt/huawei/dj/bin/zookeeper/data_arb/myid
sed -i "s#dataDir=.*#dataDir=/opt/huawei/dj/bin/zookeeper/data#g" /opt/huawei/dj/etc/zookeeper/conf/zoo.cfg
sed -i "s#dataDir=.*#dataDir=/opt/huawei/dj/bin/zookeeper/data_arb#g" /opt/huawei/dj/etc/zookeeper/conf_arb/zoo.cfg
sed -i "s#clientPortAddress.*#clientPortAddress=${LOCAL_IP}#g" /opt/huawei/dj/etc/zookeeper/conf/zoo.cfg
sed -i "s#clientPortAddress.*#clientPortAddress=${DB_FLOAT_IP}#g" /opt/huawei/dj/etc/zookeeper/conf_arb/zoo.cfg
for ((i=0;i<${#ZK_NODES[@]};i++));do
    zk_server=${ZK_NODES[i]}
    echo "server.$((i+1))=[${zk_server}]:2888:3888" >> /opt/huawei/dj/etc/zookeeper/conf/zoo.cfg
    echo "server.$((i+1))=[${zk_server}]:2888:3888" >> /opt/huawei/dj/etc/zookeeper/conf_arb/zoo.cfg
done
log_info "Finish zookeeper configuration."
