#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init zookeeper rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/zookeeper
    log_info "Finish zookeeper rsyslog configuration."
}

function install_script()
{
    log_info "Init zookeeper script configuration."
    mkdir -p /opt/huawei/dj/bin/zookeeper/{data,data_arb}
    touch /opt/huawei/dj/bin/zookeeper/data/myid
    touch /opt/huawei/dj/bin/zookeeper/data_arb/myid
    log_info "Finish zookeeper script configuration."
}

function install_tools()
{
    log_info "Init zookeeper tools configuration."
    mkdir -p /opt/huawei/dj/tools/zookeeper
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/zookeeper
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/zookeeper/zookeeperControl.sh
    log_info "Finish zookeeper tools configuration."
}

function install_version()
{
    log_info "Init zookeeper version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/zookeeper.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy zookeeper version Failed."
    log_info "Finish zookeeper version configuration."
}

function install_permission()
{
    log_info "Init zookeeper permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /var/log/huawei/dj
    log_info "Finish zookeeper permission configuration."
}

function install_conf()
{
    log_info "Init zookeeper conf configuration."
    mkdir -p /opt/huawei/dj/etc/zookeeper/{conf,conf_arb}
    /usr/bin/cp -f "${CURRENT_PATH}/conf/key.para" /opt/huawei/dj/etc/zookeeper
    /usr/bin/cp -f "${CURRENT_PATH}/conf/java.env" /opt/huawei/dj/etc/zookeeper
    /usr/bin/cp -f "${CURRENT_PATH}/conf/zkClient.conf" /opt/huawei/dj/etc/zookeeper
    /usr/bin/cp -f "${CURRENT_PATH}/conf/log4j.properties" /opt/huawei/dj/etc/zookeeper/conf
    /usr/bin/cp -f "${CURRENT_PATH}/conf/log4j.properties" /opt/huawei/dj/etc/zookeeper/conf_arb
    /usr/bin/cp -f "${CURRENT_PATH}/conf/zoo.cfg" /opt/huawei/dj/etc/zookeeper/conf
    /usr/bin/cp -f "${CURRENT_PATH}/conf/zoo.cfg" /opt/huawei/dj/etc/zookeeper/conf_arb
    log_info "Finish zookeeper conf configuration."
}

function install_root()
{
    log_info "Init zookeeper root configuration."
    log_info "Finish zookeeper root configuration."
}

function install_crontab()
{
    log_info "Init zookeeper crontab configuration."
    log_info "Finish zookeeper crontab configuration."
}

log_info "Start zookeeper installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish zookeeper installation."
