#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

log_info "Begin to install apache zookeeper..."
install_dir=/opt/huawei/dj/bin/zookeeper && mkdir -p ${install_dir}
zookeeper_tar=$(find "${LINE_ROOT}/repo/third_party" -type f -name "apache-zookeeper-*.tar.gz")
tar -xzf "${zookeeper_tar}" --no-same-owner -C ${install_dir}
CHECK_RESULT $? "Unzip apache-zookeeper failed."
/usr/bin/mv -f  ${install_dir}/apache-zookeeper*  ${install_dir}/app
CHECK_RESULT $? "Move apache-zookeeper failed"
commons_codec_jar=$(find "${LINE_ROOT}/repo/third_party" -type f -name "commons-codec-*.jar")
/usr/bin/cp -f  "${commons_codec_jar}"  ${install_dir}/app/lib
CHECK_RESULT $? "Copy commons-codec-*.jar failed"
/usr/bin/cp -f  "${LINE_ROOT}/repo/self_developed/zookeeper-auth.jar"  ${install_dir}/app/lib
CHECK_RESULT $? "Move zookeeper-auth.jar failed"
origin_text="\"-Dzookeeper.root.logger=\${ZOO_LOG4J_PROP}\""
new_text="\"-Dzookeeper.root.logger=\${ZOO_LOG4J_PROP}\" \"-Dzookeeper.admin.enableServer=false\""
sed -i "s/zookeeper.*HOSTNAME.out/zookeeper.log/" ${install_dir}/app/bin/zkServer.sh
sed -i "s/zookeeper.*HOSTNAME.log/zookeeper.log/" ${install_dir}/app/bin/zkServer.sh
sed -i "s/>\ \"\$_ZOO_DAEMON_OUT\"/>>\ \"\$_ZOO_DAEMON_OUT\"/" ${install_dir}/app/bin/zkServer.sh
sed -i "/\"x\$JMXDISABLE\"/ i JMXDISABLE=true" ${install_dir}/app/bin/zkServer.sh
sed -i "s/${origin_text}/${new_text}/g" ${install_dir}/app/bin/zkServer.sh
sed -i "25a ZOO_LOG_DIR=/var/log/huawei/dj/services/system/zookeeper" ${install_dir}/app/bin/zkEnv.sh
sed -i "25a ZOO_LOG4J_PROP=INFO,ROLLINGFILE" ${install_dir}/app/bin/zkEnv.sh
log_info "Finish install apache zookeeper successfully."