#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
source /opt/huawei/dj/etc/zookeeper/java.env
export LOG_TAG="zookeeperControl"
MODE=$(get_info profile)
ZK_CONF=/opt/huawei/dj/etc/zookeeper
ZK_SERVER=/opt/huawei/dj/bin/zookeeper/app/bin/zkServer.sh
JAVA_BIN=/opt/huawei/dj/bin/jre/bin/java


function showhelp()
{
    echo "Usage: zookeeperControl :"
    echo "  -S ServiceState <RUN|STOP|CHANGE>"
    echo "  -A RESTART"
    echo "  -CS ComponentState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "zookeeperControl: illegal option"
    showhelp
    exit 1
}

function run_container()
{
    echo_info "Begin to start zookeeper ${1}...."
    queryCmd=$(pgrep -U 51001 -f "${JAVA_BIN}.*${ZK_CONF}/${1}/zoo.cfg")
    if [[ -n "${queryCmd}" ]]; then
        echo_info "zookeeper ${1} process is running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        bash ${ZK_SERVER} --config "${ZK_CONF}/${1}" start >/dev/null 2>&1
        sleep 5
        queryCmd=$(pgrep -U 51001 -f "${JAVA_BIN}.*${ZK_CONF}/${1}/zoo.cfg")
        if [[ -z "${queryCmd}" ]]; then
            log_warn "zookeeper ${1} process is not running when start, error."
            continue
        fi
        echo_info "start zookeeper ${1} process successfully."
        return 0
    done
    ECHO_RETURN 1 "start zookeeper ${1} process failed."
}

function component_run()
{
    run_container conf
    if [[ "${MODE}" == "private_recover" ]];then
        run_container conf_arb
    fi
    echo_info "$(heartBeat START zookeeper)"
}


function stop_container()
{
    echo_info "Begin to stop zookeeper ${1}...."
    queryCmd=$(pgrep -U 51001 -f "${JAVA_BIN}.*${ZK_CONF}/${1}/zoo.cfg")
    if [[ -z "${queryCmd}" ]]; then
        echo_info "zookeeper ${1} process is not running, skip."
        return 0
    fi
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        retry=$((retry+1))
        bash ${ZK_SERVER} --config "${ZK_CONF}/${1}" stop >/dev/null 2>&1
        sleep 5
        queryCmd=$(pgrep -U 51001 -f "${JAVA_BIN}.*${ZK_CONF}/${1}/zoo.cfg")
        if [[ -n "${queryCmd}" ]]; then
            kill_process "${JAVA_BIN}.*${ZK_CONF}/${1}/zoo.cfg"
            log_warn "zookeeper ${1} process is running when stop, error."
            continue
        fi
        echo_info "stop zookeeper ${1} process successfully."
        return 0
    done
    ECHO_RETURN 1 "stop zookeeper ${1} process failed."
}

function component_stop()
{
    if [[ "${MODE}" == "private_recover" ]];then
        stop_container conf_arb
    fi
    stop_container conf
    echo_info "$(heartBeat STOP zookeeper)"
}

function component_restart()
{
    echo_info "zookeeperControl:component_restart begin"
    component_stop
    component_run
    echo_info "zookeeperControl:component_restart end"
}

function checkRun()
{
    queryCmd=$(pgrep -U 51001 -f "${JAVA_BIN}.*${ZK_CONF}/conf/zoo.cfg")
    if [[ -z "${queryCmd}" ]]; then
        ECHO_RETURN 1 "zookeeper is not running."
    fi
    if [[ "${MODE}" == "private_recover" ]];then
        queryCmd=$(pgrep -U 51001 -f "${JAVA_BIN}.*${ZK_CONF}/conf_arb/zoo.cfg")
        if [[ -z "${queryCmd}" ]]; then
            ECHO_RETURN 1 "zookeeper_arb is not running."
        fi
    fi
    zk_status=$(bash ${ZK_SERVER} --config ${ZK_CONF}/conf status | grep -w "^Mode:" | awk '{print $NF}')
    if [[ "${zk_status}" == "standalone" ]];then
        echo_info "zookeeper status is standalone"
        exit 0
    fi
    if [[ "${zk_status}" == "leader" ]];then
        echo_info "zookeeper status is leader"
        exit 2
    fi
    if [[ "${zk_status}" == "follower" ]];then
        echo_info "zookeeper status is follower"
        exit 3
    fi
    ECHO_RETURN 1 "Query status of zookeeper failed."
}

while true; do
    case "$1" in
        -S) Action1=$2;shift 2;break;;
        -CS) Action2=$2;shift 2;break;;
        -A) Action3=$2;shift 2;break;;
        -h) showhelp;break;;
        *) shift; break;;
    esac
done

if [ "RESTART" = "${Action3}" ]; then
    component_restart
elif [ "RUN" = "${Action1}" ]; then
    component_run
elif [ "STOP" = "${Action1}" ]; then
    component_stop
elif [ "ComponentState" = "${Action2}" ];then
    checkRun
else
    args_err
fi
exit 0
