# -*- coding:utf-8 -*-
import time
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.ssh_util import Ssh
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.business.param_util import ParamUtil

logger.init("eBackup CheckDatamoverStatus")


class CheckDatamoverStatus(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        params = ParamUtil()
        self.__config_dict = params.get_service_cloud_param(pod_id, "eBackup")
        self.project_id = project_id
        self.pod_id = pod_id
        self.ssh_obj = Ssh()
        self.cmd = "service hcp status" \
                   ">CheckDatamoverStatus.log 2>CheckDatamoverStatus.log"
        self.root_passwd = self.__config_dict['eBackup_os_root_password']

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """

    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.check_datamover_status()
            return Message(200)

        except HCCIException as e:
            return Message(500, e)
        except Exception as e:
            logger.error("set data disk error:%s" % str(e))
            return Message(500, e, e)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pass

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def check_datamover_status(self):
        externalom_ip_lower = \
            self.__config_dict['datamover_externalom_iplist'].lower()
        ip_list = externalom_ip_lower.split(',')
        for ip in ip_list:
            retry_times = 0
            while retry_times < 3:
                if self.check_service(ip):
                    break
                else:
                    retry_times = retry_times + 1
                    time.sleep(30)
            if retry_times == 3:
                raise HCCIException(653049, ip)

    def check_service(self, node_ip):
        ssh_client = self.ssh_obj.ssh_create_client(
            node_ip, "root", self.root_passwd)
        result = self.ssh_obj.ssh_exec_command_return(ssh_client, self.cmd)
        self.ssh_obj.ssh_close(ssh_client)
        if "last cmd result: 0\n" in result:
            logger.info("excute successful")
            return True
        else:
            logger.error("excute failed")
            return False

# the code has been updated to python3.7
