# -*- coding:utf-8 -*-
import time
from utils.DBAdapter.DBConnector import BaseOps
from utils.business.param_util import ParamUtil
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.business.project_condition_utils import get_project_conditions
from utils.common import log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.ssh_util import Ssh

from plugins.eBackup.common.api_adapter import API
from plugins.eBackup.common.ebackup_node import EBackupNode
from plugins.eBackup.scripts.common.ebackup_util import check_ip_valid
from plugins.eBackup.common.ebackup_rest import EbackupRest
from plugins.eBackup.scene.deploy.params.params_check import check_param_string


class ConnectToBusinessStorage(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        logger.init("eBackup")
        self.params = ParamUtil()
        self.project_id = project_id
        self.pod_id = pod_id
        self.rest_api = EbackupRest()
        self.ssh_obj = Ssh()
        self.token = ''
        self.session_content = ''
        self.headers = ''
        self.if_ipv6 = 0
        self.ip_list_str = ""
        self.base_url = ""
        self.datamover_iplist = None
        self.clear_history_cmd = ">~/.bash_history&&history -c&&rm -rf /home/hcp/AddDeviceManagerWhiteList.sh " \
                                 "/home/hcp/config_V3_white_list.exp"
        self.__config_dict = self.params.get_service_cloud_param(pod_id, "eBackup")
        self.hcp_passwd = self.__config_dict['hcp_ssh_password']
        self.root_passwd = self.__config_dict['eBackup_os_root_password']
        self.db = BaseOps()

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def main_handle(self, project_id, pod_id):
        condition_dic = get_project_conditions(self.project_id)
        self.ip_list_str = self.__config_dict['datamover_externalom_iplist'].lower()
        is_bc_installed = condition_dic.get('BCInstalled', '')
        if 'ManageIPV6' in condition_dic:
            self.if_ipv6 = condition_dic["ManageIPV6"]
        admin_passwd = self.__config_dict['eBackup_weblogin_password']
        if is_bc_installed:
            self.ip_list_str = self.__config_dict['existed_datamover_externalom_iplist']
            ip_lists = self.ip_list_str.split(',')
            manage_float_ip = self.__config_dict['existed_datamover_mg_float_ip'].lower()
            self.set_hcp_and_root_passwd(self.project_id, self.pod_id, "eBackupServer", ip_lists[0])
            account_info = EBackupNode(pod_id, project_id).get_account_info(manage_float_ip,
                                                                            externalom_ips=self.ip_list_str)
            if account_info.get('admin'):
                admin_passwd = account_info.get('admin')
        self.get_server_ip()
        self.login(admin_passwd)
        self.config_protected_env()
        self.logout()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        if get_project_condition_boolean(project_id, 'eBackup_Proxy'):
            return Message(200)
        try:
            self.main_handle(project_id, pod_id)
        except HCCIException as e:
            return Message(500, e)
        except Exception as e:
            logger.error(
                "server&proxy advanced config failed ,the reason is %s" % e)
            return Message(500, e, e)
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def get_server_ip(self):
        self.datamover_iplist = self.ip_list_str.split(',')
        self.base_url = \
            'https://' + self.datamover_iplist[0] + ':8088/rest/dev'
        if self.if_ipv6 == 1:
            self.base_url = \
                'https://[' + self.datamover_iplist[0] + ']:8088/rest/dev'
        if len(self.datamover_iplist) != 1:
            cmd = "grep -w listen /opt/huawei-data-protection/ebackup" \
                  "/microservice/ebk_lb/bin/nginx/conf/nginx.conf|grep -w " \
                  "8088|awk '{print $2}'|awk -F ':' '{print $1}';" \
                  "echo execute ebk_cmd result: $?"
            if self.if_ipv6 == 1:
                cmd = "grep -w listen /opt/huawei-data-protection/ebackup" \
                      "/microservice/ebk_lb/bin/nginx/conf/nginx.conf|grep" \
                      " -w 8088|awk '{print $2}'|awk -F '[' '{print $2}'|awk" \
                      " -F ']' '{print $1}';echo execute ebk_cmd result: $?"

            result = self.ssh_obj.ssh_cmds(
                self.datamover_iplist[0], cmd, "hcp",
                self.hcp_passwd, self.root_passwd, "",
                "")
            if "execute ebk_cmd result: 0" in result:
                logger.info("query listen(8088) ip succ,ip:" + result[0])
                if self.if_ipv6 == 1:
                    self.base_url = 'https://[' + result[0] + ']:8088/rest/dev'
                else:
                    self.base_url = 'https://' + result[0] + ':8088/rest/dev'
            else:
                logger.error("query listen(8088) ip failed.")

    def login(self, pwd):
        logger.info("begin to login ebackup.")
        login_url = self.base_url + '/login'
        headers = {'Accept': 'application/json'}
        # login use pwd
        data = '{"scope":0,"username":"admin","password":"' + pwd + '"}'
        rsp = self.rest_api.post(login_url, headers, data)
        if rsp.status_code != 200:
            logger.error("rest req return not 200.")
            raise HCCIException(653020)
        errcode = rsp.json()["error"]["code"]
        if errcode is None:
            logger.error("errcode is empty.")
            raise HCCIException(653020)
        if errcode == 0:
            self.token = rsp.json()["data"]["iBaseToken"]
            cookie = rsp.headers.get('Set-Cookie')
            self.session_content = cookie.split(';')[0]
            self.headers = {
                'Accept': 'application/json;version=2.2;charset=UTF-8',
                'iBaseToken': self.token,
                'Cookie': 'language=en;' + self.session_content + '; '
                                                                  'DEVICE_ID=dev; sessionIdleTime=60000; MACHINEROLE=0;'
                                                                  ' CSRF_IBASE_TOKEN=' + self.token}
            logger.info("login ebackup succ.")

    def get_protected_env(self):
        url = self.base_url + '/vbackup_hypervisor'
        rsp = self.rest_api.get(url, self.headers)
        if rsp.status_code != 200:
            logger.error("rest req return %d" % rsp.status_code)
            raise HCCIException(653020)
        errcode = rsp.json()["error"]["code"]
        description = rsp.json()["error"]["description"]
        if errcode is None or description is None:
            logger.error("errcode or description is empty.")
            raise HCCIException(653019)
        if errcode != 0:
            logger.error("get protected env failed,description:" + description)
            raise HCCIException(653029, description)
        logger.info("get proteced env info succ.")
        env_list = rsp.json()["data"]
        return env_list

    def is_exist_protected_env(self, storage_url, env_list):
        if self.if_ipv6 != 1:
            urlinfo = storage_url.split(':')
        else:
            urlinfo = []
            start_index = storage_url.find('[')
            end_index = storage_url.find(']')
            urlinfo.append(storage_url[start_index + 1:end_index])
            urlinfo.append(storage_url[(end_index + 2):])
        for sub in env_list:
            if urlinfo[0] == sub["ADDRESS"]:
                return True, urlinfo
        return False, urlinfo

    def config_protected_env(self):
        logger.info("begin to config protected env.")
        if self.__config_dict['eBackup_protected_enviroment_urllist'] == '':
            logger.info("config protected env succ.")
            return
        env_list = self.get_protected_env()
        for storage_url in \
                self.__config_dict[
                    'eBackup_protected_enviroment_urllist'].split(','):
            b_find, urlinfo = \
                self.is_exist_protected_env(storage_url, env_list)
            # add protected env if not exist
            if not b_find:
                env_id = self.add_protected_env(urlinfo)
                if not env_id:
                    continue
            # add while list
            self.add_white_list_on_device_manager(urlinfo)

            if not b_find:
                self.scan_protected_env(env_id)
            logger.info("config one protected env(%s) succ" % urlinfo[0])

    def add_protected_env(self, urlinfo):
        url = self.base_url + '/vbackup_hypervisor'
        env_name = "Environment_" + urlinfo[0].replace(".", "_")
        env_name = env_name.replace(":", "_")
        data = '{"USERNAME":"' + \
               self.__config_dict['business_storage_admin_username'] + \
               '","NAME":"' + env_name + '","PASSWORD":"' + \
               self.__config_dict['business_storage_admin_password'] + \
               '","ADDRESS":"' + \
               urlinfo[0] + '","PROTOCOL":"0","PORT":"' + \
               urlinfo[1] + '","CERT":"force_auto_match","HYPERVISORTYPE":14}'
        timeout = 0
        while timeout < 18:
            timeout += 1
            rsp = self.rest_api.post(url, self.headers, data)
            if rsp.status_code != 200:
                logger.error("rest req return %d" % rsp.status_code)
                raise HCCIException(653020)

            errcode = rsp.json()["error"]["code"]
            description = rsp.json()["error"]["description"]
            if errcode is None or description is None:
                logger.error("errcode or description is empty.")
                raise HCCIException(653019)

            if errcode != 0:
                if errcode == 1625300253:
                    time.sleep(10)
                elif errcode == 1625300248:
                    logger.info("this is a B-controller storage array")
                    return '1'
                else:
                    logger.error(
                        "add protected env failed,"
                        "description:%s." % description)
                    raise HCCIException(653029, description)

            else:
                logger.info("add protected env(%s) succ." % urlinfo[0])
                return rsp.json()["data"]["ID"]
        if timeout == 18:
            logger.error("add protected env(%s) time out." % urlinfo[0])
            raise HCCIException(653029, "time out")

    def add_white_list_on_device_manager(self, urlinfo):
        # add while list
        self.put_file_to_datamover()
        p_storage_username = \
            self.__config_dict['business_storage_superadmin_username']
        p_storage_pwd = \
            self.__config_dict['business_storage_superadmin_password']
        if not check_param_string(p_storage_username):
            raise HCCIException(653103, "business_storage_superadmin_username")
        if not check_param_string(urlinfo[0]):
            raise HCCIException(653103, 'eBackup_protected_enviroment_urllist')
        for ip in self.datamover_iplist[0:2]:
            if not check_ip_valid(ip, self.project_id):
                raise HCCIException(653103, 'datamover_externalom_iplist')
        white_list_iplist = ",".join(self.datamover_iplist[0:2])
        cmd = " chmod 550 AddDeviceManagerWhiteList.sh " \
              "config_V3_white_list.exp;dos2unix " \
              "AddDeviceManagerWhiteList.sh config_V3_white_list.exp;" \
              "/bin/bash AddDeviceManagerWhiteList.sh " \
              "'%s' '%s' '%s'" % (urlinfo[0], p_storage_username, white_list_iplist)
        check_cmd = "echo execute ebk_cmd result: $?"
        sshclient = self.ssh_obj.ssh_create_client(self.datamover_iplist[0], "hcp", self.hcp_passwd)
        self.ssh_obj.ssh_send_command(sshclient, 'su', 'assword:', 100)
        self.ssh_obj.ssh_send_command(sshclient, self.root_passwd, '#', 100)
        self.ssh_obj.ssh_send_command(sshclient, cmd, 'assword', 100)
        self.ssh_obj.ssh_send_command(sshclient, p_storage_pwd, '#', 100)
        result = self.ssh_obj.ssh_exec_command_return_list(sshclient, check_cmd, timeout=30)
        if str(result).find("execute ebk_cmd result: 0") != -1:
            logger.info("add device manager white list(%s) succ." % urlinfo[0])
            self.ssh_obj.ssh_cmds(
                self.datamover_iplist[0],
                self.clear_history_cmd, "hcp", self.hcp_passwd,
                self.root_passwd, "", "")
            logger.info("clear history succ.")
        else:
            logger.error(
                "add device manager white list(%s) failed." % urlinfo[0])
            self.ssh_obj.ssh_cmds(
                self.datamover_iplist[0],
                self.clear_history_cmd, "hcp", self.hcp_passwd,
                self.root_passwd, "", "")
            logger.info("clear history succ.")
            raise HCCIException(653031)

    def put_file_to_datamover(self):
        self.ssh_obj.put_file(
            self.datamover_iplist[0],
            "hcp", self.hcp_passwd,
            "/opt/cloud/hcci/src/HCCI/plugins/"
            "eBackup/shell_tool/AddDeviceManagerWhiteList.sh",
            ".", 22)
        self.ssh_obj.put_file(
            self.datamover_iplist[0],
            "hcp", self.hcp_passwd,
            "/opt/cloud/hcci/src/HCCI/plugins/eBackup"
            "/shell_tool/config_V3_white_list.exp",
            ".", 22)

    def scan_protected_env(self, env_id):
        # san protected env
        san_url = self.base_url + '/vbackup_hypervisor/SCAN/' + env_id
        data = '{"TYPE":57373,"ID":"' + env_id + '","AUTO_SCAN":1}'
        timeout = 0
        while timeout < 4:
            timeout += 1
            rsp = self.rest_api.put(san_url, self.headers, data)
            if rsp.status_code != 200:
                logger.error("rest req return %d" % rsp.status_code)
                raise HCCIException(653020)

            errcode = rsp.json()["error"]["code"]
            description = rsp.json()["error"]["description"]
            if errcode is None or description is None:
                logger.error("errcode or description is empty.")
                raise HCCIException(653019)

            if errcode != 0:
                if errcode == 1625300246:
                    time.sleep(20)
                else:
                    logger.error("scan protected env failed.")
                    raise HCCIException(653032, description)
            else:
                logger.info("scan protected env succ.")
                return
        if timeout == 4:
            logger.info("scan protected env time out.")
            raise HCCIException(653032, "time out")

    def logout(self):
        if self.token == '' or self.session_content == '':
            return
        url = self.base_url + '/sessions'
        self.rest_api.delete(url, self.headers)
        logger.info("log out succ.")

    def set_hcp_and_root_passwd(self, project_id, pod_id, comm, ip):
        """

        :param project_id:
        :param pod_id:
        :param comm: 组件名称: eBackupServer
        :param ip: 要查询的IP
        :return:
        """
        account_info = API.get_account_info(
            project_id, pod_id, comm)
        account_dict = account_info[ip]
        if account_dict['hcp']:
            self.hcp_passwd = account_dict['hcp']
            self.root_passwd = account_dict['root']

    def reset_old_passwd(self):
        self.hcp_passwd = self.__config_dict['hcp_ssh_password']
        self.root_passwd = self.__config_dict['eBackup_os_root_password']
# the code has been updated to python3.7
