import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.ssh_util import Ssh

from plugins.eBackup.common.util import Utils
from plugins.eBackup.scripts.upgrade.ebackup_upgrade import EbackupUpgrader


class BackupDataForeBackup(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(BackupDataForeBackup, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self._db_param_dict = Utils.init_system_params(project_id, regionid_list[0])

    def check(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("start to backup all data for eBackup.")
        host_list = [self._db_param_dict["eBackup_Datamover_nodes"]]
        backup_host = []
        for host in host_list:
            backup_host.extend(host.replace(" ", "").replace("|", ";").split(";"))

        def do_execute():
            real_need_backup_host = []
            search_bak_dir_cmd = "[ -f /var/ebackup_bak/ebackup/bin/AdminNode ] && echo 'Dir exist'"
            hcp_pwd = self._db_param_dict.get("eBackup_hcp_pwd")
            root_pwd = self._db_param_dict.get("eBackup_root_pwd")
            for host in backup_host:
                ssh_client = Utils.get_ssh_client(host, 'hcp', hcp_pwd, root_pwd)
                result = Ssh.ssh_exec_command_return(ssh_client, search_bak_dir_cmd)
                if str(result).find("Dir exist") == -1:
                    real_need_backup_host.append(host)
                Utils.close_ssh_clinet(ssh_client)
            if not real_need_backup_host:
                logger.info("Data on all nodes has been backed up, skip.")
                return

            ebackup_upgrader = EbackupUpgrader(real_need_backup_host, self._db_param_dict)
            fail_reason = "Failed to process backup DMK Task, please check the DMK log."
            is_true = False
            try:
                is_true = ebackup_upgrader.backup()
            except Exception as e:
                fail_reason = str(e)
            if not is_true:
                logger.error(f"Fail to backup all data. reason: {fail_reason}")
                raise HCCIException(650062)
            logger.info("Success to backup all data for eBackup")

        try:
            do_execute()
        except Exception as ex:
            return Message(500, error_msg_cn="备份数据出现异常，请查看日志并重试, 异常信息：%s" % str(ex),
                           error_msg_en=f"Exception occurs when backup data, "
                                        f"please see log and try again, errof info:{str(ex)}")
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list=None):
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        return self.execute(project_id, pod_id, regionid_list)
