# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.manageone_util2 import ManageOneUtil2
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message

from plugins.eBackup.common.util import Utils

PACKAGE_PATTERN = "^resource_10UnifiedAccess2MO_eBackup_(.*)\\.tar\\.gz$"
MO_EXCEPT_CODE = "404"


class RollBackAdaptationPackage(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list):
        super(RollBackAdaptationPackage, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        self.region_id = self.regionid_list[0]

    def execute(self, project_id, pod_id, regionid_list=None):
        """
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return: Message object
        """
        try:
            self.rollback_adaptation_package()
        except Exception as ex:
            return Message(500, ex)
        return Message(200)

    def rollback_adaptation_package(self):
        adaptation_pkg_info_path = "".join(
            ['adaptation_pkg_info_',
             str(self.project_id), "_",
             self.region_id]
        )
        old_version = Utils.get_value_from_config_file(adaptation_pkg_info_path)
        logger.info(f"Begin to rollback eBackup adaptation package, target origin version: {old_version}")

        result = ManageOneUtil2().rollback_adaptation_package(self.project_id, self.region_id, "eBackup", old_version)
        if result.get("status") == "failed" and MO_EXCEPT_CODE not in str(result["msg"]):
            message = result.get("msg")
            logger.error(f"eBackup rollback adaptation package failed : {message}")
            raise HCCIException(f"eBackup rollback adaptation package failed : {message}")
        logger.info("End to rollback eBackup adaptation package to OC successfully")

    def retry(self, project_id, pod_id, regionid_list=None):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id, regionid_list)
