#!/bin/bash
set +x
G_MIN_FREE_MEM=$[600*1024]  #mix free mem is 600MB
G_PATH_NAME="./" #store ultraPath softwer packet path
G_INSTALL_SCRIPT_NAME="install.sh" #install ultraPath script file
G_INSTALL_CONFIG_NAME="unattend_install.conf" #config ultraPath file
G_REAL_FREE_MEM=$(cat /proc/meminfo |grep MemFree |awk '{print $2}')
G_GET_DATE=$(date "+%Y_%m_%d/%T")
currentPath=$(pwd)


#return number: 1 express faild to install ultraPath
#return number: 2 express faild to config 
function install_ultraPath()
{   
    echo "" > $currentPath/ultraPath.log

    local find=$(rpm -qa|grep Ul)  #get wheather have installed UltraPath
    if [ ! -z ${find} ];then
        echo "install ultrapath succ"
        echo "${G_GET_DATE}: ultraPath have installed" >>  $currentPath/ultraPath.log
        return 0
    fi

    if (( G_MIN_FREE_MEM > G_REAL_FREE_MEM ));then
       echo "${G_GET_DATE}: free memeory is smaller than 600MB" >>  $currentPath/ultraPath.log
       return 1
    fi

    local fileName=$(ls ${G_PATH_NAME} | grep ^OceanStor.*UltraPath.*LinuxOther.zip)

    if [ ! -z ${fileName} ];then

        unzip ${fileName} -d ${fileName%.zip}
        if [ ! -d ${fileName%.zip} ];then 
            echo "${G_GET_DATE}: can't find ultraPath unzip file" >> $currentPath/ultraPath.log
            return 1
        fi

        systemctl disable multipathd.service > /dev/null 2>&1
        systemctl stop multipathd.service > /dev/null 2>&1

        cd ${fileName%.zip}/LinuxOther
        chmod +x ${G_INSTALL_SCRIPT_NAME}
 
        if [ -e ${G_INSTALL_CONFIG_NAME} ];then
            sh ${G_INSTALL_SCRIPT_NAME} -f ${G_INSTALL_CONFIG_NAME}
        else
            echo "${G_GET_DATE}: can't find config file" >>  $currentPath/ultraPath.log
            sh ${G_INSTALL_SCRIPT_NAME}
        fi

        if (($? != 2)); then
            echo "${G_GET_DATE}: install ultraPath faild" >>  $currentPath/ultraPath.log
            return 1
        else
            local checkIbCard=$(lspci | grep Mellanox)
            if [ ! -z ${checkIbCard} ];then
                upLinux config ib
                if [ $? ne 0];then
                    echo "${G_GET_DATE}: config ib faild" >>  $currentPath/ultraPath.log
                    return 2
                fi
            fi

            echo Y | upLinux updateImage   #update image
            if [ ! $? -eq 0 ];then
                echo "${G_GET_DATE}: faild to update image" >>  $currentPath/ultraPath.log
                return 2
            fi
           
            ls /etc/init.d/nxup >>/dev/null
            if [ $? -ne 0 ];then
                echo "${G_GET_DATE}: can not find nxup file to start ultraPath service" >>  $currentPath/ultraPath.log
                return 2
            fi


            echo Y | /etc/init.d/nxup start
            if [ $? -ne 0 ];then
                echo "${G_GET_DATE}: start ultraPath faild" >>  $currentPath/ultraPath.log
                return 2
            fi
        fi

    else
        echo "${G_GET_DATE}: can't find ultraPath packet" >>  $currentPath/ultraPath.log
        return 1
    fi
    echo "install ultrapath succ" 
    echo "${G_GET_DATE}: install ultraPath succeed" >>  $currentPath/ultraPath.log
    return 0
}

main()
{

    install_ultraPath
    local ret=$?
    
    cd ${currentPath}
    local fileName=$(ls ${G_PATH_NAME} | grep ^OceanStor.*UltraPath.*LinuxOther.zip)
    if [ -d ${fileName%.zip} ];then
        rm -fr ${fileName%.zip}
    fi
    
    return ${ret}
}

main $*
>~/.bash_history&&history -c
exit $?
